/*
* Copyright (C) 2019 ~ 2019 Uniontech Technology Co., Ltd.
*
* Author:     liaojiayun <liaojiayun@uniontech.com>
*
* Maintainer: liaojiayun <liaojiayun@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef BASE_TABLE_TREE_VIEW_H
#define BASE_TABLE_TREE_VIEW_H

#include <DTreeView>

DWIDGET_USE_NAMESPACE

class BaseItemDelegateV20;
class BaseHeaderViewV20;
class QModelIndex;

class BaseTableTreeView : public DTreeView
{
    Q_OBJECT

public:
    BaseTableTreeView(DWidget *parent = nullptr);
    void setControlAttrInLive(); // 仅供 live 环境下调用

protected:
    void paintEvent(QPaintEvent *event) override;
    void drawRow(QPainter *painter, const QStyleOptionViewItem &options,
                 const QModelIndex &index) const override;
    void currentChanged(const QModelIndex &current, const QModelIndex &previous) override;
    bool viewportEvent(QEvent *event) override;

private:
    BaseItemDelegateV20 *m_itemDelegate {nullptr};
    BaseHeaderViewV20 *m_headerView {nullptr};

    QModelIndex m_hover;
    QModelIndex m_pressed;
};

#endif  // BASE_TABLE_TREE_VIEW_H
