//
// Created by uos on 2022/3/18.
//

#ifndef UOS_RECOVERY_UTILS_H
#define UOS_RECOVERY_UTILS_H

#include <QPixmap>
#include <QImageReader>
#include <QApplication>
#include <QJsonObject>
#include <QJsonDocument>
#include <polkit-qt6-1/PolkitQt1/Authority>
#include <QTime>

struct CpuInfo {
    int cpuNum = -1;
    QString modelName = "";
    QString byteOrder = "";
    QString arch = "";
};

namespace GhostPolicy {
    const int GHOST_POLICY_UNKOWN = -1;
    const int GHOST_POLICY_LVM_ONE_DISK = 1; // 非加密场景: 是否支持单磁盘lvm, 包括全盘安装和手动安装
    const int GHOST_POLICY_LVM_MULTI_DISK = 2; // 非加密场景: 是否支持多磁盘lvm, 包括全盘安装和手动安装
    const int GHOST_POLICY_ENCRYPT_ONE_DISK = 3; // 加密场景: 是否支持单磁盘全盘安装
    const int GHOST_POLICY_ENCRYPT_MULTI_DISK = 4; // 加密场景: 是否支持多磁盘全盘安装
    const int GHOST_POLICY_GHOST_TOOL = 5; // 只显示Ghost
};

namespace UI {
    const int UI_BACKUP_MODULE = 1;
    const int UI_RESTORE_MODULE = 2;
    const int UI_ADVANCE_MODULE = 3;

    const int UI_LAYOUT_BACKUP_VERTICAL = 1001; // default backup layout
    const int UI_LAYOUT_BACKUP_HORIZONTAL = 1002;

    const int UI_LAYOUT_RESTORE_VERTICAL = 2001; // default restore layout
    const int UI_LAYOUT_RESTORE_HORIZONTAL = 2002;

    const int UI_LAYOUT_ADVANCE_VERTICAL = 3001; // default advance layout
    const int UI_LAYOUT_ADVANCE_HORIZONTAL = 3002;
}

using namespace PolkitQt1;

namespace Utils {

    // treeview中Time字段固定宽度
    static const int timeFieldStretchWidth = 160;
    static const int strechSpace = 5;

    // the margin of radioitem‘s content
    static const int contentMargin = 3;

//    enum class ErrorType {
//        NoError = 0,
//        SpaceError,     //磁盘空间不足
//        FsError,        //文件系统不支持
//        PathError,      //不是有效路径
//        LocationError,  //路径位置不允许
//        MD5Error,       //备份文件错误
//        DeviceReadOnly, // 只读设备，不允许备份
//        BackupPathError, // 备份文件路径位置错误
//        UNKOWN          //其他未知错误
//    };

    enum class BackupType {
        AddBackup,          //增量备份
        CoverBackup,        //覆盖备份
        CoverRestore        //覆盖点还原
    };

    QPixmap loadSvgImage(const QString& strPath, int iWidth, int iHeight);

    QPixmap renderSVG(const QString &path, const QSize &size);

    QJsonObject QStringToJson(const QString &jsonString);

    QString JsonToQString(const QJsonObject &jsonObject);
    const QJsonObject readPathfromJsonFile(const QString &path);

    const QPixmap hidpiPixmap(const QString &path, const QSize &sz);
    bool calculateDirSize(const QString &dirPath, const QStringList &excludeDir, quint64 &totalSizeBytes,
                          QString &error, bool samePartition = false);

    QString getUserName();

    bool authorization(); // 管理员用户的鉴权，针对需要输入管理员账户密码的场景
    bool checkCommonUserAuthentication(); // 普通用户的鉴权，需要认证，但是用户可以只输入自己的密码，不需要属于管理员。

    bool readJsonFile(const QString &filepath, QJsonDocument &destdoc);
    bool writeJsonFile(const QString &filepath, const QJsonDocument &destdoc);

    QString byte2DisplaySize(quint64 size);
    quint64 parsePartitionSize(const QString& jsonString);
    bool isAdminUser(const QString &userName);
    bool isAdminUserByDbus(const QString &userName, const QString &servicePath, const QString &accountPath,
                           const QString &accountInterfacePath, const QString &userInterfacePath);
    bool isAdminUserBySysCall(const QString &userName);
    bool isUserExist(const QString &userName);
    bool isOStree();
    bool isImmutableSystem();
    quint64 getRemainSecond(const int &progress, QTime &baseTime);
    QString getOSVersion();
    QString getOSVersionDisplay(bool localeEnglish = false);
    bool getDestPartInfoByDir(const QString &selectDir, QJsonObject &destInfo, QString &err);
    int currentPlatformByString(const QString &platform);
    bool isEFIMode();
    bool isSystemUpgrade();
    bool getLsblkJsonReturn(const QStringList &cmdArgs, QJsonArray &jsonOut, QString &err);
    bool getDimFileJsonInfo(const QString &fileName, QJsonObject &fileInfo, QString &err);
    int filterDevice(QJsonArray &deviceArray);// 根据配置的设备类型过滤设备，返回过滤后剩余设备的数量
    bool getFormatPartitionCmd(const QString& label, const QString& filesystem, const QString& path, QString &cmd, QString &err);
    int getCPUCores();
    bool getProcessNameByPid(pid_t pid, QString &name);
    QString getKernelArch();
    QString getOSEditionType();
    bool isCommunity();
    QString getGhostFileName(const QString &curTime);
    bool isLVM(bool &isEnrypted);
    bool getCpuInfo(CpuInfo &cpu);
    bool getVGAFromLshw(QString &display);
    bool getLshwInfo(QList<QPair<QString, QString>> &lshwMap);
    QStringList getAllSystemBackupUUID(const QString &recoveryConf);
    bool getFsTypeAndDevicePathByDir(const QString &dir, QString &fsType, QString &devicePath);
    bool isDeviceRemoveable(const QString &devicePath);
    int getGhostPolicy(const QString &recoveryConf);
    int getUILayoutType(int module);
    // Layout Direction, return true when Direction is from Right to Left. eg: $LANG = ug_CN
    bool isDirectionRTL();
    int getOSMajorVersion(const QString &osVersionPath);
    bool isDeepinBootKitExist();
    bool isGhostOnly();
    bool reboot(bool ignoreOthers, bool hasRootPrivilege);
    quint64 getAllSystemBackupSize();
    bool getPlatformInfo(QString &hardwareType, QString &sysProductName, QString &huaweiTypeAlias, bool &isHuawei);
    bool getSwapPartitionSize(const QString &path, qint64 &size);
    bool isEnableImmutableSystemWritable();
}


#endif //UOS_RECOVERY_UTILS_H
