/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>

#include <iostream>
#include <algorithm>

#include <QtDBus/QDBusConnection>
#include <QCoreApplication>
#include "dbusadaptor.h"
#include "dbus.h"

int main(int argc, char **argv)
{
    QCoreApplication app(argc, argv);

    PolkitProhibitedDBus *dbus = new PolkitProhibitedDBus;
    new DBusAdaptor(dbus);

    QDBusConnection connection = QDBusConnection::sessionBus();
    qDebug() << connection.isConnected();
    if(!connection.registerService("com.deepin.prohibitscreenshot") || !connection.registerObject("/com/deepin/prohibitscreenshot", dbus)) {
        qDebug() << connection.lastError();
        app.exit(1);
        return 1;
    }
    return app.exec();
}
