//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbilling

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// AddressClient contains the methods for the Address group.
// Don't use this type directly, use NewAddressClient() instead.
type AddressClient struct {
	host string
	pl   runtime.Pipeline
}

// NewAddressClient creates a new instance of AddressClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewAddressClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*AddressClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &AddressClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// Validate - Validates an address. Use the operation to validate an address before using it as soldTo or a billTo address.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// options - AddressClientValidateOptions contains the optional parameters for the AddressClient.Validate method.
func (client *AddressClient) Validate(ctx context.Context, address AddressDetails, options *AddressClientValidateOptions) (AddressClientValidateResponse, error) {
	req, err := client.validateCreateRequest(ctx, address, options)
	if err != nil {
		return AddressClientValidateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AddressClientValidateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AddressClientValidateResponse{}, runtime.NewResponseError(resp)
	}
	return client.validateHandleResponse(resp)
}

// validateCreateRequest creates the Validate request.
func (client *AddressClient) validateCreateRequest(ctx context.Context, address AddressDetails, options *AddressClientValidateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/validateAddress"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, address)
}

// validateHandleResponse handles the Validate response.
func (client *AddressClient) validateHandleResponse(resp *http.Response) (AddressClientValidateResponse, error) {
	result := AddressClientValidateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ValidateAddressResponse); err != nil {
		return AddressClientValidateResponse{}, err
	}
	return result, nil
}
