//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcommunication

import "time"

// CheckNameAvailabilityRequest - The check availability request body.
type CheckNameAvailabilityRequest struct {
	// The name of the resource for which availability needs to be checked.
	Name *string `json:"name,omitempty"`

	// The resource type.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse - The check availability result.
type CheckNameAvailabilityResponse struct {
	// Detailed reason why the given name is available.
	Message *string `json:"message,omitempty"`

	// Indicates if the resource name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason why the given name is not available.
	Reason *CheckNameAvailabilityReason `json:"reason,omitempty"`
}

// DNSRecord - A class that represents a VerificationStatus record.
type DNSRecord struct {
	// READ-ONLY; Name of the DNS record.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Represents an expiry time in seconds to represent how long this entry can be cached by the resolver, default
	// = 3600sec.
	TTL *int32 `json:"ttl,omitempty" azure:"ro"`

	// READ-ONLY; Type of the DNS record. Example: TXT
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Value of the DNS record.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// DomainProperties - A class that describes the properties of a Domains resource.
type DomainProperties struct {
	// REQUIRED; Describes how a Domains resource is being managed.
	DomainManagement *DomainManagement `json:"domainManagement,omitempty"`

	// Describes whether user engagement tracking is enabled or disabled.
	UserEngagementTracking *UserEngagementTracking `json:"userEngagementTracking,omitempty"`

	// Collection of valid sender usernames. This is a key-value pair where key=username and value=display name.
	ValidSenderUsernames map[string]*string `json:"validSenderUsernames,omitempty"`

	// READ-ONLY; The location where the Domains resource data is stored at rest.
	DataLocation *string `json:"dataLocation,omitempty" azure:"ro"`

	// READ-ONLY; P2 sender domain that is displayed to the email recipients [RFC 5322].
	FromSenderDomain *string `json:"fromSenderDomain,omitempty" azure:"ro"`

	// READ-ONLY; P1 sender domain that is present on the email envelope [RFC 5321].
	MailFromSenderDomain *string `json:"mailFromSenderDomain,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *DomainsProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; List of DnsRecord
	VerificationRecords *DomainPropertiesVerificationRecords `json:"verificationRecords,omitempty" azure:"ro"`

	// READ-ONLY; List of VerificationStatusRecord
	VerificationStates *DomainPropertiesVerificationStates `json:"verificationStates,omitempty" azure:"ro"`
}

// DomainPropertiesVerificationRecords - List of DnsRecord
type DomainPropertiesVerificationRecords struct {
	// A class that represents a VerificationStatus record.
	DKIM *DNSRecord `json:"DKIM,omitempty"`

	// A class that represents a VerificationStatus record.
	DKIM2 *DNSRecord `json:"DKIM2,omitempty"`

	// A class that represents a VerificationStatus record.
	DMARC *DNSRecord `json:"DMARC,omitempty"`

	// A class that represents a VerificationStatus record.
	Domain *DNSRecord `json:"Domain,omitempty"`

	// A class that represents a VerificationStatus record.
	SPF *DNSRecord `json:"SPF,omitempty"`
}

// DomainPropertiesVerificationStates - List of VerificationStatusRecord
type DomainPropertiesVerificationStates struct {
	// A class that represents a VerificationStatus record.
	DKIM *VerificationStatusRecord `json:"DKIM,omitempty"`

	// A class that represents a VerificationStatus record.
	DKIM2 *VerificationStatusRecord `json:"DKIM2,omitempty"`

	// A class that represents a VerificationStatus record.
	DMARC *VerificationStatusRecord `json:"DMARC,omitempty"`

	// A class that represents a VerificationStatus record.
	Domain *VerificationStatusRecord `json:"Domain,omitempty"`

	// A class that represents a VerificationStatus record.
	SPF *VerificationStatusRecord `json:"SPF,omitempty"`
}

// DomainResource - A class representing a Domains resource.
type DomainResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The properties of a Domains resource.
	Properties *DomainProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DomainResourceList - Object that includes an array of Domains resource and a possible link for next set.
type DomainResourceList struct {
	// The URL the client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Domains resource
	Value []*DomainResource `json:"value,omitempty"`
}

// DomainsClientBeginCancelVerificationOptions contains the optional parameters for the DomainsClient.BeginCancelVerification
// method.
type DomainsClientBeginCancelVerificationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainsClientBeginCreateOrUpdateOptions contains the optional parameters for the DomainsClient.BeginCreateOrUpdate method.
type DomainsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainsClientBeginDeleteOptions contains the optional parameters for the DomainsClient.BeginDelete method.
type DomainsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainsClientBeginInitiateVerificationOptions contains the optional parameters for the DomainsClient.BeginInitiateVerification
// method.
type DomainsClientBeginInitiateVerificationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainsClientBeginUpdateOptions contains the optional parameters for the DomainsClient.BeginUpdate method.
type DomainsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainsClientGetOptions contains the optional parameters for the DomainsClient.Get method.
type DomainsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientListByEmailServiceResourceOptions contains the optional parameters for the DomainsClient.ListByEmailServiceResource
// method.
type DomainsClientListByEmailServiceResourceOptions struct {
	// placeholder for future optional parameters
}

// EmailServiceProperties - A class that describes the properties of the EmailService.
type EmailServiceProperties struct {
	// REQUIRED; The location where the email service stores its data at rest.
	DataLocation *string `json:"dataLocation,omitempty"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *EmailServicesProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// EmailServiceResource - A class representing an EmailService resource.
type EmailServiceResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The properties of the service.
	Properties *EmailServiceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EmailServiceResourceList - Object that includes an array of EmailServices and a possible link for next set.
type EmailServiceResourceList struct {
	// The URL the client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// List of EmailService
	Value []*EmailServiceResource `json:"value,omitempty"`
}

// EmailServiceResourceUpdate - A class representing update parameters for EmailService resource.
type EmailServiceResourceUpdate struct {
	// Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// EmailServicesClientBeginCreateOrUpdateOptions contains the optional parameters for the EmailServicesClient.BeginCreateOrUpdate
// method.
type EmailServicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EmailServicesClientBeginDeleteOptions contains the optional parameters for the EmailServicesClient.BeginDelete method.
type EmailServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EmailServicesClientBeginUpdateOptions contains the optional parameters for the EmailServicesClient.BeginUpdate method.
type EmailServicesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EmailServicesClientGetOptions contains the optional parameters for the EmailServicesClient.Get method.
type EmailServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// EmailServicesClientListByResourceGroupOptions contains the optional parameters for the EmailServicesClient.ListByResourceGroup
// method.
type EmailServicesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// EmailServicesClientListBySubscriptionOptions contains the optional parameters for the EmailServicesClient.ListBySubscription
// method.
type EmailServicesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// EmailServicesClientListVerifiedExchangeOnlineDomainsOptions contains the optional parameters for the EmailServicesClient.ListVerifiedExchangeOnlineDomains
// method.
type EmailServicesClientListVerifiedExchangeOnlineDomainsOptions struct {
	// placeholder for future optional parameters
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// LinkNotificationHubParameters - Description of an Azure Notification Hub to link to the communication service
type LinkNotificationHubParameters struct {
	// REQUIRED; Connection string for the notification hub
	ConnectionString *string `json:"connectionString,omitempty"`

	// REQUIRED; The resource ID of the notification hub
	ResourceID *string `json:"resourceId,omitempty"`
}

// LinkedNotificationHub - A notification hub that has been linked to the communication service
type LinkedNotificationHub struct {
	// The resource ID of the notification hub
	ResourceID *string `json:"resourceId,omitempty"`
}

// NameAvailabilityParameters - Data POST-ed to the nameAvailability action
type NameAvailabilityParameters struct {
	// The name of the resource for which availability needs to be checked.
	Name *string `json:"name,omitempty"`

	// The resource type.
	Type *string `json:"type,omitempty"`
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType `json:"actionType,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// RegenerateKeyParameters - Parameters describes the request to regenerate access keys
type RegenerateKeyParameters struct {
	// The keyType to regenerate. Must be either 'primary' or 'secondary'(case-insensitive).
	KeyType *KeyType `json:"keyType,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceKeys - A class representing the access keys of a CommunicationService.
type ServiceKeys struct {
	// CommunicationService connection string constructed via the primaryKey
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`

	// The primary access key.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// CommunicationService connection string constructed via the secondaryKey
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`

	// The secondary access key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// ServiceProperties - A class that describes the properties of the CommunicationService.
type ServiceProperties struct {
	// REQUIRED; The location where the communication service stores its data at rest.
	DataLocation *string `json:"dataLocation,omitempty"`

	// List of email Domain resource Ids.
	LinkedDomains []*string `json:"linkedDomains,omitempty"`

	// READ-ONLY; FQDN of the CommunicationService instance.
	HostName *string `json:"hostName,omitempty" azure:"ro"`

	// READ-ONLY; The immutable resource Id of the communication service.
	ImmutableResourceID *string `json:"immutableResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID of an Azure Notification Hub linked to this resource.
	NotificationHubID *string `json:"notificationHubId,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *CommunicationServicesProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Version of the CommunicationService resource. Probably you need the same or higher version of client SDKs.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// ServiceResource - A class representing a CommunicationService resource.
type ServiceResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The properties of the service.
	Properties *ServiceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceResourceList - Object that includes an array of CommunicationServices and a possible link for next set.
type ServiceResourceList struct {
	// The URL the client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// List of CommunicationService
	Value []*ServiceResource `json:"value,omitempty"`
}

// ServiceResourceUpdate - A class representing update parameters for CommunicationService resource.
type ServiceResourceUpdate struct {
	// The properties of the service.
	Properties *ServiceUpdateProperties `json:"properties,omitempty"`

	// Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ServiceUpdateProperties - A class that describes the properties that can be updated for CommunicationService resource.
type ServiceUpdateProperties struct {
	// List of email Domain resource Ids.
	LinkedDomains []*string `json:"linkedDomains,omitempty"`
}

// ServicesClientBeginCreateOrUpdateOptions contains the optional parameters for the ServicesClient.BeginCreateOrUpdate method.
type ServicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginDeleteOptions contains the optional parameters for the ServicesClient.BeginDelete method.
type ServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginRegenerateKeyOptions contains the optional parameters for the ServicesClient.BeginRegenerateKey method.
type ServicesClientBeginRegenerateKeyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginUpdateOptions contains the optional parameters for the ServicesClient.BeginUpdate method.
type ServicesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientCheckNameAvailabilityOptions contains the optional parameters for the ServicesClient.CheckNameAvailability
// method.
type ServicesClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientGetOptions contains the optional parameters for the ServicesClient.Get method.
type ServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientLinkNotificationHubOptions contains the optional parameters for the ServicesClient.LinkNotificationHub method.
type ServicesClientLinkNotificationHubOptions struct {
	// Parameters supplied to the operation.
	LinkNotificationHubParameters *LinkNotificationHubParameters
}

// ServicesClientListByResourceGroupOptions contains the optional parameters for the ServicesClient.ListByResourceGroup method.
type ServicesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListBySubscriptionOptions contains the optional parameters for the ServicesClient.ListBySubscription method.
type ServicesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListKeysOptions contains the optional parameters for the ServicesClient.ListKeys method.
type ServicesClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TaggedResource - An ARM resource with that can accept tags
type TaggedResource struct {
	// Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpdateDomainProperties - A class that describes the updatable properties of a Domains resource.
type UpdateDomainProperties struct {
	// Describes whether user engagement tracking is enabled or disabled.
	UserEngagementTracking *UserEngagementTracking `json:"userEngagementTracking,omitempty"`

	// Collection of valid sender usernames. This is a key-value pair where key=username and value=display name.
	ValidSenderUsernames map[string]*string `json:"validSenderUsernames,omitempty"`
}

// UpdateDomainRequestParameters - A class that describes the PATCH request parameters of a Domains resource.
type UpdateDomainRequestParameters struct {
	// A class that describes the updatable properties of a Domains resource.
	Properties *UpdateDomainProperties `json:"properties,omitempty"`

	// Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// VerificationParameter - Input parameter for verification APIs
type VerificationParameter struct {
	// REQUIRED; Type of verification.
	VerificationType *VerificationType `json:"verificationType,omitempty"`
}

// VerificationStatusRecord - A class that represents a VerificationStatus record.
type VerificationStatusRecord struct {
	// READ-ONLY; Error code. This property will only be present if the status is UnableToVerify.
	ErrorCode *string `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; Status of the verification operation.
	Status *VerificationStatus `json:"status,omitempty" azure:"ro"`
}
