//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdevops

// Authorization info used to access a resource (like code repository).
type Authorization struct {
	// REQUIRED; Type of authorization.
	AuthorizationType *AuthorizationType `json:"authorizationType,omitempty"`

	// Authorization parameters corresponding to the authorization type.
	Parameters map[string]*string `json:"parameters,omitempty"`
}

// BootstrapConfiguration - Configuration used to bootstrap a Pipeline.
type BootstrapConfiguration struct {
	// REQUIRED; Template used to bootstrap the pipeline.
	Template *PipelineTemplate `json:"template,omitempty"`

	// Repository containing the source code for the pipeline.
	Repository *CodeRepository `json:"repository,omitempty"`
}

// CloudError - An error response from the Pipelines Resource Provider.
type CloudError struct {
	// Details of the error from the Pipelines Resource Provider.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from the Pipelines Resource Provider.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error or the method where the error occurred.
	Target *string `json:"target,omitempty"`
}

// CodeRepository - Repository containing the source code for a pipeline.
type CodeRepository struct {
	// REQUIRED; Default branch used to configure Continuous Integration (CI) in the pipeline.
	DefaultBranch *string `json:"defaultBranch,omitempty"`

	// REQUIRED; Unique immutable identifier of the code repository.
	ID *string `json:"id,omitempty"`

	// REQUIRED; Type of code repository.
	RepositoryType *CodeRepositoryType `json:"repositoryType,omitempty"`

	// Authorization info to access the code repository.
	Authorization *Authorization `json:"authorization,omitempty"`

	// Repository-specific properties.
	Properties map[string]*string `json:"properties,omitempty"`
}

// InputDescriptor - Representation of a pipeline template input parameter.
type InputDescriptor struct {
	// REQUIRED; Identifier of the input parameter.
	ID *string `json:"id,omitempty"`

	// REQUIRED; Data type of the value of the input parameter.
	Type *InputDataType `json:"type,omitempty"`

	// Description of the input parameter.
	Description *string `json:"description,omitempty"`

	// List of possible values for the input parameter.
	PossibleValues []*InputValue `json:"possibleValues,omitempty"`
}

// InputValue - Representation of a pipeline template input parameter value.
type InputValue struct {
	// Description of the input parameter value.
	DisplayValue *string `json:"displayValue,omitempty"`

	// Value of an input parameter.
	Value *string `json:"value,omitempty"`
}

// Operation - Properties of an Operation.
type Operation struct {
	// Display information of the operation.
	Display *OperationDisplayValue `json:"display,omitempty"`

	// Indicates whether the operation applies to data-plane.
	IsDataAction *string `json:"isDataAction,omitempty"`

	// READ-ONLY; Name of the operation.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplayValue - Display information of an operation.
type OperationDisplayValue struct {
	// READ-ONLY; Friendly description of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Friendly name of the operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Friendly name of the resource provider.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Friendly name of the resource type the operation applies to.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result of a request to list all operations supported by Microsoft.DevOps resource provider.
type OperationListResult struct {
	// The URL to get the next set of operations, if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of operations supported by Microsoft.DevOps resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OrganizationReference - Reference to an Azure DevOps Organization.
type OrganizationReference struct {
	// REQUIRED; Name of the Azure DevOps Organization.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; Unique immutable identifier for the Azure DevOps Organization.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// Pipeline - Azure DevOps Pipeline used to configure Continuous Integration (CI) & Continuous Delivery (CD) for Azure resources.
type Pipeline struct {
	// REQUIRED; Custom properties of the Pipeline.
	Properties *PipelineProperties `json:"properties,omitempty"`

	// Resource Location
	Location *string `json:"location,omitempty"`

	// Resource Tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PipelineListResult - Result of a request to list all Azure Pipelines under a given scope.
type PipelineListResult struct {
	// URL to get the next set of Pipelines, if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of pipelines.
	Value []*Pipeline `json:"value,omitempty"`
}

// PipelineProperties - Custom properties of a Pipeline.
type PipelineProperties struct {
	// REQUIRED; Configuration used to bootstrap the Pipeline.
	BootstrapConfiguration *BootstrapConfiguration `json:"bootstrapConfiguration,omitempty"`

	// REQUIRED; Reference to the Azure DevOps Organization containing the Pipeline.
	Organization *OrganizationReference `json:"organization,omitempty"`

	// REQUIRED; Reference to the Azure DevOps Project containing the Pipeline.
	Project *ProjectReference `json:"project,omitempty"`

	// READ-ONLY; Unique identifier of the Azure Pipeline within the Azure DevOps Project.
	PipelineID *int32 `json:"pipelineId,omitempty" azure:"ro"`
}

// PipelineTemplate - Template used to bootstrap the pipeline.
type PipelineTemplate struct {
	// REQUIRED; Unique identifier of the pipeline template.
	ID *string `json:"id,omitempty"`

	// Dictionary of input parameters used in the pipeline template.
	Parameters map[string]*string `json:"parameters,omitempty"`
}

// PipelineTemplateDefinition - Definition of a pipeline template.
type PipelineTemplateDefinition struct {
	// REQUIRED; Unique identifier of the pipeline template.
	ID *string `json:"id,omitempty"`

	// Description of the pipeline enabled by the template.
	Description *string `json:"description,omitempty"`

	// List of input parameters required by the template to create a pipeline.
	Inputs []*InputDescriptor `json:"inputs,omitempty"`
}

// PipelineTemplateDefinitionListResult - Result of a request to list all pipeline template definitions.
type PipelineTemplateDefinitionListResult struct {
	// The URL to get the next set of pipeline template definitions, if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of pipeline template definitions.
	Value []*PipelineTemplateDefinition `json:"value,omitempty"`
}

// PipelineTemplateDefinitionsClientListOptions contains the optional parameters for the PipelineTemplateDefinitionsClient.List
// method.
type PipelineTemplateDefinitionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PipelineUpdateParameters - Request payload used to update an existing Azure Pipeline.
type PipelineUpdateParameters struct {
	// Dictionary of key-value pairs to be set as tags on the Azure Pipeline. This will overwrite any existing tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// PipelinesClientBeginCreateOrUpdateOptions contains the optional parameters for the PipelinesClient.BeginCreateOrUpdate
// method.
type PipelinesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PipelinesClientDeleteOptions contains the optional parameters for the PipelinesClient.Delete method.
type PipelinesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PipelinesClientGetOptions contains the optional parameters for the PipelinesClient.Get method.
type PipelinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PipelinesClientListByResourceGroupOptions contains the optional parameters for the PipelinesClient.ListByResourceGroup
// method.
type PipelinesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PipelinesClientListBySubscriptionOptions contains the optional parameters for the PipelinesClient.ListBySubscription method.
type PipelinesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// PipelinesClientUpdateOptions contains the optional parameters for the PipelinesClient.Update method.
type PipelinesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProjectReference - Reference to an Azure DevOps Project.
type ProjectReference struct {
	// REQUIRED; Name of the Azure DevOps Project.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; Unique immutable identifier of the Azure DevOps Project.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// Resource - An Azure Resource Manager (ARM) resource.
type Resource struct {
	// Resource Location
	Location *string `json:"location,omitempty"`

	// Resource Tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}
