//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnotificationhubs

import "time"

// AdmCredential - Description of a NotificationHub AdmCredential.
type AdmCredential struct {
	// Properties of NotificationHub AdmCredential.
	Properties *AdmCredentialProperties `json:"properties,omitempty"`
}

// AdmCredentialProperties - Description of a NotificationHub AdmCredential.
type AdmCredentialProperties struct {
	// The URL of the authorization token.
	AuthTokenURL *string `json:"authTokenUrl,omitempty"`

	// The client identifier.
	ClientID *string `json:"clientId,omitempty"`

	// The credential secret access key.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// ApnsCredential - Description of a NotificationHub ApnsCredential.
type ApnsCredential struct {
	// Properties of NotificationHub ApnsCredential.
	Properties *ApnsCredentialProperties `json:"properties,omitempty"`
}

// ApnsCredentialProperties - Description of a NotificationHub ApnsCredential. Note that there is no explicit switch between
// Certificate and Token Authentication Modes. The mode is determined based on the properties passed in.
type ApnsCredentialProperties struct {
	// The APNS certificate. Specify if using Certificate Authentication Mode.
	ApnsCertificate *string `json:"apnsCertificate,omitempty"`

	// The issuer (iss) registered claim key. The value is a 10-character TeamId, obtained from your developer account. Specify
	// if using Token Authentication Mode.
	AppID *string `json:"appId,omitempty"`

	// The name of the application or BundleId. Specify if using Token Authentication Mode.
	AppName *string `json:"appName,omitempty"`

	// The APNS certificate password if it exists.
	CertificateKey *string `json:"certificateKey,omitempty"`

	// The APNS endpoint of this credential. If using Certificate Authentication Mode and Sandbox specify 'gateway.sandbox.push.apple.com'.
	// If using Certificate Authentication Mode and Production specify
	// 'gateway.push.apple.com'. If using Token Authentication Mode and Sandbox specify 'https://api.development.push.apple.com:443/3/device'.
	// If using Token Authentication Mode and Production specify
	// 'https://api.push.apple.com:443/3/device'.
	Endpoint *string `json:"endpoint,omitempty"`

	// A 10-character key identifier (kid) key, obtained from your developer account. Specify if using Token Authentication Mode.
	KeyID *string `json:"keyId,omitempty"`

	// The APNS certificate thumbprint. Specify if using Certificate Authentication Mode.
	Thumbprint *string `json:"thumbprint,omitempty"`

	// Provider Authentication Token, obtained through your developer account. Specify if using Token Authentication Mode.
	Token *string `json:"token,omitempty"`
}

// BaiduCredential - Description of a NotificationHub BaiduCredential.
type BaiduCredential struct {
	// Properties of NotificationHub BaiduCredential.
	Properties *BaiduCredentialProperties `json:"properties,omitempty"`
}

// BaiduCredentialProperties - Description of a NotificationHub BaiduCredential.
type BaiduCredentialProperties struct {
	// Baidu Api Key.
	BaiduAPIKey *string `json:"baiduApiKey,omitempty"`

	// Baidu Endpoint.
	BaiduEndPoint *string `json:"baiduEndPoint,omitempty"`

	// Baidu Secret Key
	BaiduSecretKey *string `json:"baiduSecretKey,omitempty"`
}

// CheckAvailabilityParameters - Parameters supplied to the Check Name Availability for Namespace and NotificationHubs.
type CheckAvailabilityParameters struct {
	// REQUIRED; Resource name
	Name *string `json:"name,omitempty"`

	// True if the name is available and can be used to create new Namespace/NotificationHub. Otherwise false.
	IsAvailiable *bool `json:"isAvailiable,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// The sku of the created namespace
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CheckAvailabilityResult - Description of a CheckAvailability resource.
type CheckAvailabilityResult struct {
	// True if the name is available and can be used to create new Namespace/NotificationHub. Otherwise false.
	IsAvailiable *bool `json:"isAvailiable,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// The sku of the created namespace
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClientCheckNotificationHubAvailabilityOptions contains the optional parameters for the Client.CheckNotificationHubAvailability
// method.
type ClientCheckNotificationHubAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ClientCreateOrUpdateAuthorizationRuleOptions contains the optional parameters for the Client.CreateOrUpdateAuthorizationRule
// method.
type ClientCreateOrUpdateAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// ClientCreateOrUpdateOptions contains the optional parameters for the Client.CreateOrUpdate method.
type ClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ClientDebugSendOptions contains the optional parameters for the Client.DebugSend method.
type ClientDebugSendOptions struct {
	// Debug send parameters
	Parameters interface{}
}

// ClientDeleteAuthorizationRuleOptions contains the optional parameters for the Client.DeleteAuthorizationRule method.
type ClientDeleteAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// ClientDeleteOptions contains the optional parameters for the Client.Delete method.
type ClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ClientGetAuthorizationRuleOptions contains the optional parameters for the Client.GetAuthorizationRule method.
type ClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// ClientGetOptions contains the optional parameters for the Client.Get method.
type ClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClientGetPnsCredentialsOptions contains the optional parameters for the Client.GetPnsCredentials method.
type ClientGetPnsCredentialsOptions struct {
	// placeholder for future optional parameters
}

// ClientListAuthorizationRulesOptions contains the optional parameters for the Client.ListAuthorizationRules method.
type ClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// ClientListKeysOptions contains the optional parameters for the Client.ListKeys method.
type ClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// ClientListOptions contains the optional parameters for the Client.List method.
type ClientListOptions struct {
	// placeholder for future optional parameters
}

// ClientPatchOptions contains the optional parameters for the Client.Patch method.
type ClientPatchOptions struct {
	// Parameters supplied to patch a NotificationHub Resource.
	Parameters *NotificationHubPatchParameters
}

// ClientRegenerateKeysOptions contains the optional parameters for the Client.RegenerateKeys method.
type ClientRegenerateKeysOptions struct {
	// placeholder for future optional parameters
}

// DebugSendResponse - Description of a NotificationHub Resource.
type DebugSendResponse struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Properties of the NotificationHub.
	Properties *DebugSendResult `json:"properties,omitempty"`

	// The sku of the created namespace
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

type DebugSendResult struct {
	// send failure
	Failure *float32 `json:"failure,omitempty"`

	// actual failure description
	Results interface{} `json:"results,omitempty"`

	// successful send
	Success *float32 `json:"success,omitempty"`
}

// ErrorResponse - Error response indicates NotificationHubs service is not able to process the incoming request. The reason
// is provided in the error message.
type ErrorResponse struct {
	// Error code.
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// GCMCredential - Description of a NotificationHub GcmCredential.
type GCMCredential struct {
	// Properties of NotificationHub GcmCredential.
	Properties *GCMCredentialProperties `json:"properties,omitempty"`
}

// GCMCredentialProperties - Description of a NotificationHub GcmCredential.
type GCMCredentialProperties struct {
	// The FCM legacy endpoint. Default value is 'https://fcm.googleapis.com/fcm/send'
	GCMEndpoint *string `json:"gcmEndpoint,omitempty"`

	// The Google API key.
	GoogleAPIKey *string `json:"googleApiKey,omitempty"`
}

// MpnsCredential - Description of a NotificationHub MpnsCredential.
type MpnsCredential struct {
	// Properties of NotificationHub MpnsCredential.
	Properties *MpnsCredentialProperties `json:"properties,omitempty"`
}

// MpnsCredentialProperties - Description of a NotificationHub MpnsCredential.
type MpnsCredentialProperties struct {
	// The certificate key for this credential.
	CertificateKey *string `json:"certificateKey,omitempty"`

	// The MPNS certificate.
	MpnsCertificate *string `json:"mpnsCertificate,omitempty"`

	// The MPNS certificate Thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// NamespaceCreateOrUpdateParameters - Parameters supplied to the CreateOrUpdate Namespace operation.
type NamespaceCreateOrUpdateParameters struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Properties of the Namespace.
	Properties *NamespaceProperties `json:"properties,omitempty"`

	// The sku of the created namespace
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NamespaceListResult - The response of the List Namespace operation.
type NamespaceListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of Namespaces
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List Namespace operation.
	Value []*NamespaceResource `json:"value,omitempty"`
}

// NamespacePatchParameters - Parameters supplied to the Patch Namespace operation.
type NamespacePatchParameters struct {
	// The sku of the created namespace
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// NamespaceProperties - Namespace properties.
type NamespaceProperties struct {
	// The time the namespace was created.
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// Whether or not the namespace is set as Critical.
	Critical *bool `json:"critical,omitempty"`

	// Data center for the namespace
	DataCenter *string `json:"dataCenter,omitempty"`

	// Whether or not the namespace is currently enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// The name of the namespace.
	Name *string `json:"name,omitempty"`

	// The namespace type.
	NamespaceType *NamespaceType `json:"namespaceType,omitempty"`

	// Provisioning state of the Namespace.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Specifies the targeted region in which the namespace should be created. It can be any of the following values: Australia
	// East, Australia Southeast, Central US, East US, East US 2, West US, North
	// Central US, South Central US, East Asia, Southeast Asia, Brazil South, Japan East, Japan West, North Europe, West Europe
	Region *string `json:"region,omitempty"`

	// ScaleUnit where the namespace gets created
	ScaleUnit *string `json:"scaleUnit,omitempty"`

	// Endpoint you can use to perform NotificationHub operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty"`

	// Status of the namespace. It can be any of these values:1 = Created/Active2 = Creating3 = Suspended4 = Deleting
	Status *string `json:"status,omitempty"`

	// The Id of the Azure subscription associated with the namespace.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// The time the namespace was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty"`

	// READ-ONLY; Identifier for Azure Insights metrics
	MetricID *string `json:"metricId,omitempty" azure:"ro"`
}

// NamespaceResource - Description of a Namespace resource.
type NamespaceResource struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Properties of the Namespace.
	Properties *NamespaceProperties `json:"properties,omitempty"`

	// The sku of the created namespace
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NamespacesClientBeginDeleteOptions contains the optional parameters for the NamespacesClient.BeginDelete method.
type NamespacesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamespacesClientCheckAvailabilityOptions contains the optional parameters for the NamespacesClient.CheckAvailability method.
type NamespacesClientCheckAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientCreateOrUpdateAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.CreateOrUpdateAuthorizationRule
// method.
type NamespacesClientCreateOrUpdateAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientCreateOrUpdateOptions contains the optional parameters for the NamespacesClient.CreateOrUpdate method.
type NamespacesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientDeleteAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.DeleteAuthorizationRule
// method.
type NamespacesClientDeleteAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientGetAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.GetAuthorizationRule
// method.
type NamespacesClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientGetOptions contains the optional parameters for the NamespacesClient.Get method.
type NamespacesClientGetOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListAllOptions contains the optional parameters for the NamespacesClient.ListAll method.
type NamespacesClientListAllOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListAuthorizationRulesOptions contains the optional parameters for the NamespacesClient.ListAuthorizationRules
// method.
type NamespacesClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListKeysOptions contains the optional parameters for the NamespacesClient.ListKeys method.
type NamespacesClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListOptions contains the optional parameters for the NamespacesClient.List method.
type NamespacesClientListOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientPatchOptions contains the optional parameters for the NamespacesClient.Patch method.
type NamespacesClientPatchOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientRegenerateKeysOptions contains the optional parameters for the NamespacesClient.RegenerateKeys method.
type NamespacesClientRegenerateKeysOptions struct {
	// placeholder for future optional parameters
}

// NotificationHubCreateOrUpdateParameters - Parameters supplied to the CreateOrUpdate NotificationHub operation.
type NotificationHubCreateOrUpdateParameters struct {
	// REQUIRED; Properties of the NotificationHub.
	Properties *NotificationHubProperties `json:"properties,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// The sku of the created namespace
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NotificationHubListResult - The response of the List NotificationHub operation.
type NotificationHubListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of NotificationHub
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List NotificationHub operation.
	Value []*NotificationHubResource `json:"value,omitempty"`
}

// NotificationHubPatchParameters - Parameters supplied to the patch NotificationHub operation.
type NotificationHubPatchParameters struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Properties of the NotificationHub.
	Properties *NotificationHubProperties `json:"properties,omitempty"`

	// The sku of the created namespace
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NotificationHubProperties - NotificationHub properties.
type NotificationHubProperties struct {
	// The AdmCredential of the created NotificationHub
	AdmCredential *AdmCredential `json:"admCredential,omitempty"`

	// The ApnsCredential of the created NotificationHub
	ApnsCredential *ApnsCredential `json:"apnsCredential,omitempty"`

	// The AuthorizationRules of the created NotificationHub
	AuthorizationRules []*SharedAccessAuthorizationRuleProperties `json:"authorizationRules,omitempty"`

	// The BaiduCredential of the created NotificationHub
	BaiduCredential *BaiduCredential `json:"baiduCredential,omitempty"`

	// The GcmCredential of the created NotificationHub
	GCMCredential *GCMCredential `json:"gcmCredential,omitempty"`

	// The MpnsCredential of the created NotificationHub
	MpnsCredential *MpnsCredential `json:"mpnsCredential,omitempty"`

	// The NotificationHub name.
	Name *string `json:"name,omitempty"`

	// The RegistrationTtl of the created NotificationHub
	RegistrationTTL *string `json:"registrationTtl,omitempty"`

	// The WnsCredential of the created NotificationHub
	WnsCredential *WnsCredential `json:"wnsCredential,omitempty"`
}

// NotificationHubResource - Description of a NotificationHub Resource.
type NotificationHubResource struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Properties of the NotificationHub.
	Properties *NotificationHubProperties `json:"properties,omitempty"`

	// The sku of the created namespace
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Operation - A NotificationHubs REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Service provider: Microsoft.NotificationHubs
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result of the request to list NotificationHubs operations. It contains a list of operations and a
// URL link to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of NotificationHubs operations supported by the Microsoft.NotificationHubs resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PnsCredentialsProperties - Description of a NotificationHub PNS Credentials.
type PnsCredentialsProperties struct {
	// The AdmCredential of the created NotificationHub
	AdmCredential *AdmCredential `json:"admCredential,omitempty"`

	// The ApnsCredential of the created NotificationHub
	ApnsCredential *ApnsCredential `json:"apnsCredential,omitempty"`

	// The BaiduCredential of the created NotificationHub
	BaiduCredential *BaiduCredential `json:"baiduCredential,omitempty"`

	// The GcmCredential of the created NotificationHub
	GCMCredential *GCMCredential `json:"gcmCredential,omitempty"`

	// The MpnsCredential of the created NotificationHub
	MpnsCredential *MpnsCredential `json:"mpnsCredential,omitempty"`

	// The WnsCredential of the created NotificationHub
	WnsCredential *WnsCredential `json:"wnsCredential,omitempty"`
}

// PnsCredentialsResource - Description of a NotificationHub PNS Credentials.
type PnsCredentialsResource struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// NotificationHub PNS Credentials.
	Properties *PnsCredentialsProperties `json:"properties,omitempty"`

	// The sku of the created namespace
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PolicykeyResource - Namespace/NotificationHub Regenerate Keys
type PolicykeyResource struct {
	// Name of the key that has to be regenerated for the Namespace/Notification Hub Authorization Rule. The value can be Primary
	// Key/Secondary Key.
	PolicyKey *string `json:"policyKey,omitempty"`
}

type Resource struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// The sku of the created namespace
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceListKeys - Namespace/NotificationHub Connection String
type ResourceListKeys struct {
	// KeyName of the created AuthorizationRule
	KeyName *string `json:"keyName,omitempty"`

	// PrimaryConnectionString of the AuthorizationRule.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`

	// PrimaryKey of the created AuthorizationRule.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// SecondaryConnectionString of the created AuthorizationRule
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`

	// SecondaryKey of the created AuthorizationRule
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// SKU - The Sku description for a namespace
type SKU struct {
	// REQUIRED; Name of the notification hub sku
	Name *SKUName `json:"name,omitempty"`

	// The capacity of the resource
	Capacity *int32 `json:"capacity,omitempty"`

	// The Sku Family
	Family *string `json:"family,omitempty"`

	// The Sku size
	Size *string `json:"size,omitempty"`

	// The tier of particular sku
	Tier *string `json:"tier,omitempty"`
}

// SharedAccessAuthorizationRuleCreateOrUpdateParameters - Parameters supplied to the CreateOrUpdate Namespace AuthorizationRules.
type SharedAccessAuthorizationRuleCreateOrUpdateParameters struct {
	// REQUIRED; Properties of the Namespace AuthorizationRules.
	Properties *SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`
}

// SharedAccessAuthorizationRuleListResult - The response of the List Namespace operation.
type SharedAccessAuthorizationRuleListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of AuthorizationRules
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List AuthorizationRules operation.
	Value []*SharedAccessAuthorizationRuleResource `json:"value,omitempty"`
}

// SharedAccessAuthorizationRuleProperties - SharedAccessAuthorizationRule properties.
type SharedAccessAuthorizationRuleProperties struct {
	// The rights associated with the rule.
	Rights []*AccessRights `json:"rights,omitempty"`

	// READ-ONLY; A string that describes the claim type
	ClaimType *string `json:"claimType,omitempty" azure:"ro"`

	// READ-ONLY; A string that describes the claim value
	ClaimValue *string `json:"claimValue,omitempty" azure:"ro"`

	// READ-ONLY; The created time for this rule
	CreatedTime *string `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; A string that describes the authorization rule.
	KeyName *string `json:"keyName,omitempty" azure:"ro"`

	// READ-ONLY; The last modified time for this rule
	ModifiedTime *string `json:"modifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	PrimaryKey *string `json:"primaryKey,omitempty" azure:"ro"`

	// READ-ONLY; The revision number for the rule
	Revision *int32 `json:"revision,omitempty" azure:"ro"`

	// READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	SecondaryKey *string `json:"secondaryKey,omitempty" azure:"ro"`
}

// SharedAccessAuthorizationRuleResource - Description of a Namespace AuthorizationRules.
type SharedAccessAuthorizationRuleResource struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Properties of the Namespace AuthorizationRule.
	Properties *SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`

	// The sku of the created namespace
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

type SubResource struct {
	// Resource Id
	ID *string `json:"id,omitempty"`
}

// WnsCredential - Description of a NotificationHub WnsCredential.
type WnsCredential struct {
	// Properties of NotificationHub WnsCredential.
	Properties *WnsCredentialProperties `json:"properties,omitempty"`
}

// WnsCredentialProperties - Description of a NotificationHub WnsCredential.
type WnsCredentialProperties struct {
	// The package ID for this credential.
	PackageSid *string `json:"packageSid,omitempty"`

	// The secret key.
	SecretKey *string `json:"secretKey,omitempty"`

	// The Windows Live endpoint.
	WindowsLiveEndpoint *string `json:"windowsLiveEndpoint,omitempty"`
}
