//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AlertsClient contains the methods for the Alerts group.
// Don't use this type directly, use NewAlertsClient() instead.
type AlertsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewAlertsClient creates a new instance of AlertsClient with the specified values.
// subscriptionID - Azure subscription ID
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewAlertsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AlertsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &AlertsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// GetResourceGroupLevel - Get an alert that is associated a resource group or a resource in a resource group
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// ascLocation - The location where ASC stores the data of the subscription. can be retrieved from Get locations
// alertName - Name of the alert object
// options - AlertsClientGetResourceGroupLevelOptions contains the optional parameters for the AlertsClient.GetResourceGroupLevel
// method.
func (client *AlertsClient) GetResourceGroupLevel(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *AlertsClientGetResourceGroupLevelOptions) (AlertsClientGetResourceGroupLevelResponse, error) {
	req, err := client.getResourceGroupLevelCreateRequest(ctx, resourceGroupName, ascLocation, alertName, options)
	if err != nil {
		return AlertsClientGetResourceGroupLevelResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AlertsClientGetResourceGroupLevelResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AlertsClientGetResourceGroupLevelResponse{}, runtime.NewResponseError(resp)
	}
	return client.getResourceGroupLevelHandleResponse(resp)
}

// getResourceGroupLevelCreateRequest creates the GetResourceGroupLevel request.
func (client *AlertsClient) getResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *AlertsClientGetResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if ascLocation == "" {
		return nil, errors.New("parameter ascLocation cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ascLocation}", url.PathEscape(ascLocation))
	if alertName == "" {
		return nil, errors.New("parameter alertName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertName}", url.PathEscape(alertName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getResourceGroupLevelHandleResponse handles the GetResourceGroupLevel response.
func (client *AlertsClient) getResourceGroupLevelHandleResponse(resp *http.Response) (AlertsClientGetResourceGroupLevelResponse, error) {
	result := AlertsClientGetResourceGroupLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Alert); err != nil {
		return AlertsClientGetResourceGroupLevelResponse{}, err
	}
	return result, nil
}

// GetSubscriptionLevel - Get an alert that is associated with a subscription
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// ascLocation - The location where ASC stores the data of the subscription. can be retrieved from Get locations
// alertName - Name of the alert object
// options - AlertsClientGetSubscriptionLevelOptions contains the optional parameters for the AlertsClient.GetSubscriptionLevel
// method.
func (client *AlertsClient) GetSubscriptionLevel(ctx context.Context, ascLocation string, alertName string, options *AlertsClientGetSubscriptionLevelOptions) (AlertsClientGetSubscriptionLevelResponse, error) {
	req, err := client.getSubscriptionLevelCreateRequest(ctx, ascLocation, alertName, options)
	if err != nil {
		return AlertsClientGetSubscriptionLevelResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AlertsClientGetSubscriptionLevelResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AlertsClientGetSubscriptionLevelResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSubscriptionLevelHandleResponse(resp)
}

// getSubscriptionLevelCreateRequest creates the GetSubscriptionLevel request.
func (client *AlertsClient) getSubscriptionLevelCreateRequest(ctx context.Context, ascLocation string, alertName string, options *AlertsClientGetSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if ascLocation == "" {
		return nil, errors.New("parameter ascLocation cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ascLocation}", url.PathEscape(ascLocation))
	if alertName == "" {
		return nil, errors.New("parameter alertName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertName}", url.PathEscape(alertName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSubscriptionLevelHandleResponse handles the GetSubscriptionLevel response.
func (client *AlertsClient) getSubscriptionLevelHandleResponse(resp *http.Response) (AlertsClientGetSubscriptionLevelResponse, error) {
	result := AlertsClientGetSubscriptionLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Alert); err != nil {
		return AlertsClientGetSubscriptionLevelResponse{}, err
	}
	return result, nil
}

// NewListPager - List all the alerts that are associated with the subscription
// Generated from API version 2022-01-01
// options - AlertsClientListOptions contains the optional parameters for the AlertsClient.List method.
func (client *AlertsClient) NewListPager(options *AlertsClientListOptions) *runtime.Pager[AlertsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[AlertsClientListResponse]{
		More: func(page AlertsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AlertsClientListResponse) (AlertsClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return AlertsClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AlertsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AlertsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *AlertsClient) listCreateRequest(ctx context.Context, options *AlertsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/alerts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *AlertsClient) listHandleResponse(resp *http.Response) (AlertsClientListResponse, error) {
	result := AlertsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AlertList); err != nil {
		return AlertsClientListResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - List all the alerts that are associated with the resource group
// Generated from API version 2022-01-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// options - AlertsClientListByResourceGroupOptions contains the optional parameters for the AlertsClient.ListByResourceGroup
// method.
func (client *AlertsClient) NewListByResourceGroupPager(resourceGroupName string, options *AlertsClientListByResourceGroupOptions) *runtime.Pager[AlertsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[AlertsClientListByResourceGroupResponse]{
		More: func(page AlertsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AlertsClientListByResourceGroupResponse) (AlertsClientListByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return AlertsClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AlertsClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AlertsClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *AlertsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *AlertsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/alerts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *AlertsClient) listByResourceGroupHandleResponse(resp *http.Response) (AlertsClientListByResourceGroupResponse, error) {
	result := AlertsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AlertList); err != nil {
		return AlertsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListResourceGroupLevelByRegionPager - List all the alerts that are associated with the resource group that are stored
// in a specific location
// Generated from API version 2022-01-01
// ascLocation - The location where ASC stores the data of the subscription. can be retrieved from Get locations
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// options - AlertsClientListResourceGroupLevelByRegionOptions contains the optional parameters for the AlertsClient.ListResourceGroupLevelByRegion
// method.
func (client *AlertsClient) NewListResourceGroupLevelByRegionPager(ascLocation string, resourceGroupName string, options *AlertsClientListResourceGroupLevelByRegionOptions) *runtime.Pager[AlertsClientListResourceGroupLevelByRegionResponse] {
	return runtime.NewPager(runtime.PagingHandler[AlertsClientListResourceGroupLevelByRegionResponse]{
		More: func(page AlertsClientListResourceGroupLevelByRegionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AlertsClientListResourceGroupLevelByRegionResponse) (AlertsClientListResourceGroupLevelByRegionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listResourceGroupLevelByRegionCreateRequest(ctx, ascLocation, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return AlertsClientListResourceGroupLevelByRegionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AlertsClientListResourceGroupLevelByRegionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AlertsClientListResourceGroupLevelByRegionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listResourceGroupLevelByRegionHandleResponse(resp)
		},
	})
}

// listResourceGroupLevelByRegionCreateRequest creates the ListResourceGroupLevelByRegion request.
func (client *AlertsClient) listResourceGroupLevelByRegionCreateRequest(ctx context.Context, ascLocation string, resourceGroupName string, options *AlertsClientListResourceGroupLevelByRegionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if ascLocation == "" {
		return nil, errors.New("parameter ascLocation cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ascLocation}", url.PathEscape(ascLocation))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listResourceGroupLevelByRegionHandleResponse handles the ListResourceGroupLevelByRegion response.
func (client *AlertsClient) listResourceGroupLevelByRegionHandleResponse(resp *http.Response) (AlertsClientListResourceGroupLevelByRegionResponse, error) {
	result := AlertsClientListResourceGroupLevelByRegionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AlertList); err != nil {
		return AlertsClientListResourceGroupLevelByRegionResponse{}, err
	}
	return result, nil
}

// NewListSubscriptionLevelByRegionPager - List all the alerts that are associated with the subscription that are stored in
// a specific location
// Generated from API version 2022-01-01
// ascLocation - The location where ASC stores the data of the subscription. can be retrieved from Get locations
// options - AlertsClientListSubscriptionLevelByRegionOptions contains the optional parameters for the AlertsClient.ListSubscriptionLevelByRegion
// method.
func (client *AlertsClient) NewListSubscriptionLevelByRegionPager(ascLocation string, options *AlertsClientListSubscriptionLevelByRegionOptions) *runtime.Pager[AlertsClientListSubscriptionLevelByRegionResponse] {
	return runtime.NewPager(runtime.PagingHandler[AlertsClientListSubscriptionLevelByRegionResponse]{
		More: func(page AlertsClientListSubscriptionLevelByRegionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AlertsClientListSubscriptionLevelByRegionResponse) (AlertsClientListSubscriptionLevelByRegionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSubscriptionLevelByRegionCreateRequest(ctx, ascLocation, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return AlertsClientListSubscriptionLevelByRegionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AlertsClientListSubscriptionLevelByRegionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AlertsClientListSubscriptionLevelByRegionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSubscriptionLevelByRegionHandleResponse(resp)
		},
	})
}

// listSubscriptionLevelByRegionCreateRequest creates the ListSubscriptionLevelByRegion request.
func (client *AlertsClient) listSubscriptionLevelByRegionCreateRequest(ctx context.Context, ascLocation string, options *AlertsClientListSubscriptionLevelByRegionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if ascLocation == "" {
		return nil, errors.New("parameter ascLocation cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ascLocation}", url.PathEscape(ascLocation))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSubscriptionLevelByRegionHandleResponse handles the ListSubscriptionLevelByRegion response.
func (client *AlertsClient) listSubscriptionLevelByRegionHandleResponse(resp *http.Response) (AlertsClientListSubscriptionLevelByRegionResponse, error) {
	result := AlertsClientListSubscriptionLevelByRegionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AlertList); err != nil {
		return AlertsClientListSubscriptionLevelByRegionResponse{}, err
	}
	return result, nil
}

// BeginSimulate - Simulate security alerts
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// ascLocation - The location where ASC stores the data of the subscription. can be retrieved from Get locations
// alertSimulatorRequestBody - Alert Simulator Request Properties
// options - AlertsClientBeginSimulateOptions contains the optional parameters for the AlertsClient.BeginSimulate method.
func (client *AlertsClient) BeginSimulate(ctx context.Context, ascLocation string, alertSimulatorRequestBody AlertSimulatorRequestBody, options *AlertsClientBeginSimulateOptions) (*runtime.Poller[AlertsClientSimulateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.simulate(ctx, ascLocation, alertSimulatorRequestBody, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[AlertsClientSimulateResponse]{
			FinalStateVia: runtime.FinalStateViaOriginalURI,
		})
	} else {
		return runtime.NewPollerFromResumeToken[AlertsClientSimulateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Simulate - Simulate security alerts
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
func (client *AlertsClient) simulate(ctx context.Context, ascLocation string, alertSimulatorRequestBody AlertSimulatorRequestBody, options *AlertsClientBeginSimulateOptions) (*http.Response, error) {
	req, err := client.simulateCreateRequest(ctx, ascLocation, alertSimulatorRequestBody, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// simulateCreateRequest creates the Simulate request.
func (client *AlertsClient) simulateCreateRequest(ctx context.Context, ascLocation string, alertSimulatorRequestBody AlertSimulatorRequestBody, options *AlertsClientBeginSimulateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/default/simulate"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if ascLocation == "" {
		return nil, errors.New("parameter ascLocation cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ascLocation}", url.PathEscape(ascLocation))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, alertSimulatorRequestBody)
}

// UpdateResourceGroupLevelStateToActivate - Update the alert's state
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// ascLocation - The location where ASC stores the data of the subscription. can be retrieved from Get locations
// alertName - Name of the alert object
// options - AlertsClientUpdateResourceGroupLevelStateToActivateOptions contains the optional parameters for the AlertsClient.UpdateResourceGroupLevelStateToActivate
// method.
func (client *AlertsClient) UpdateResourceGroupLevelStateToActivate(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *AlertsClientUpdateResourceGroupLevelStateToActivateOptions) (AlertsClientUpdateResourceGroupLevelStateToActivateResponse, error) {
	req, err := client.updateResourceGroupLevelStateToActivateCreateRequest(ctx, resourceGroupName, ascLocation, alertName, options)
	if err != nil {
		return AlertsClientUpdateResourceGroupLevelStateToActivateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AlertsClientUpdateResourceGroupLevelStateToActivateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return AlertsClientUpdateResourceGroupLevelStateToActivateResponse{}, runtime.NewResponseError(resp)
	}
	return AlertsClientUpdateResourceGroupLevelStateToActivateResponse{}, nil
}

// updateResourceGroupLevelStateToActivateCreateRequest creates the UpdateResourceGroupLevelStateToActivate request.
func (client *AlertsClient) updateResourceGroupLevelStateToActivateCreateRequest(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *AlertsClientUpdateResourceGroupLevelStateToActivateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/activate"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if ascLocation == "" {
		return nil, errors.New("parameter ascLocation cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ascLocation}", url.PathEscape(ascLocation))
	if alertName == "" {
		return nil, errors.New("parameter alertName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertName}", url.PathEscape(alertName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// UpdateResourceGroupLevelStateToDismiss - Update the alert's state
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// ascLocation - The location where ASC stores the data of the subscription. can be retrieved from Get locations
// alertName - Name of the alert object
// options - AlertsClientUpdateResourceGroupLevelStateToDismissOptions contains the optional parameters for the AlertsClient.UpdateResourceGroupLevelStateToDismiss
// method.
func (client *AlertsClient) UpdateResourceGroupLevelStateToDismiss(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *AlertsClientUpdateResourceGroupLevelStateToDismissOptions) (AlertsClientUpdateResourceGroupLevelStateToDismissResponse, error) {
	req, err := client.updateResourceGroupLevelStateToDismissCreateRequest(ctx, resourceGroupName, ascLocation, alertName, options)
	if err != nil {
		return AlertsClientUpdateResourceGroupLevelStateToDismissResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AlertsClientUpdateResourceGroupLevelStateToDismissResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return AlertsClientUpdateResourceGroupLevelStateToDismissResponse{}, runtime.NewResponseError(resp)
	}
	return AlertsClientUpdateResourceGroupLevelStateToDismissResponse{}, nil
}

// updateResourceGroupLevelStateToDismissCreateRequest creates the UpdateResourceGroupLevelStateToDismiss request.
func (client *AlertsClient) updateResourceGroupLevelStateToDismissCreateRequest(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *AlertsClientUpdateResourceGroupLevelStateToDismissOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/dismiss"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if ascLocation == "" {
		return nil, errors.New("parameter ascLocation cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ascLocation}", url.PathEscape(ascLocation))
	if alertName == "" {
		return nil, errors.New("parameter alertName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertName}", url.PathEscape(alertName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// UpdateResourceGroupLevelStateToInProgress - Update the alert's state
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// ascLocation - The location where ASC stores the data of the subscription. can be retrieved from Get locations
// alertName - Name of the alert object
// options - AlertsClientUpdateResourceGroupLevelStateToInProgressOptions contains the optional parameters for the AlertsClient.UpdateResourceGroupLevelStateToInProgress
// method.
func (client *AlertsClient) UpdateResourceGroupLevelStateToInProgress(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *AlertsClientUpdateResourceGroupLevelStateToInProgressOptions) (AlertsClientUpdateResourceGroupLevelStateToInProgressResponse, error) {
	req, err := client.updateResourceGroupLevelStateToInProgressCreateRequest(ctx, resourceGroupName, ascLocation, alertName, options)
	if err != nil {
		return AlertsClientUpdateResourceGroupLevelStateToInProgressResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AlertsClientUpdateResourceGroupLevelStateToInProgressResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return AlertsClientUpdateResourceGroupLevelStateToInProgressResponse{}, runtime.NewResponseError(resp)
	}
	return AlertsClientUpdateResourceGroupLevelStateToInProgressResponse{}, nil
}

// updateResourceGroupLevelStateToInProgressCreateRequest creates the UpdateResourceGroupLevelStateToInProgress request.
func (client *AlertsClient) updateResourceGroupLevelStateToInProgressCreateRequest(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *AlertsClientUpdateResourceGroupLevelStateToInProgressOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/inProgress"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if ascLocation == "" {
		return nil, errors.New("parameter ascLocation cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ascLocation}", url.PathEscape(ascLocation))
	if alertName == "" {
		return nil, errors.New("parameter alertName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertName}", url.PathEscape(alertName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// UpdateResourceGroupLevelStateToResolve - Update the alert's state
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// ascLocation - The location where ASC stores the data of the subscription. can be retrieved from Get locations
// alertName - Name of the alert object
// options - AlertsClientUpdateResourceGroupLevelStateToResolveOptions contains the optional parameters for the AlertsClient.UpdateResourceGroupLevelStateToResolve
// method.
func (client *AlertsClient) UpdateResourceGroupLevelStateToResolve(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *AlertsClientUpdateResourceGroupLevelStateToResolveOptions) (AlertsClientUpdateResourceGroupLevelStateToResolveResponse, error) {
	req, err := client.updateResourceGroupLevelStateToResolveCreateRequest(ctx, resourceGroupName, ascLocation, alertName, options)
	if err != nil {
		return AlertsClientUpdateResourceGroupLevelStateToResolveResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AlertsClientUpdateResourceGroupLevelStateToResolveResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return AlertsClientUpdateResourceGroupLevelStateToResolveResponse{}, runtime.NewResponseError(resp)
	}
	return AlertsClientUpdateResourceGroupLevelStateToResolveResponse{}, nil
}

// updateResourceGroupLevelStateToResolveCreateRequest creates the UpdateResourceGroupLevelStateToResolve request.
func (client *AlertsClient) updateResourceGroupLevelStateToResolveCreateRequest(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *AlertsClientUpdateResourceGroupLevelStateToResolveOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/resolve"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if ascLocation == "" {
		return nil, errors.New("parameter ascLocation cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ascLocation}", url.PathEscape(ascLocation))
	if alertName == "" {
		return nil, errors.New("parameter alertName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertName}", url.PathEscape(alertName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// UpdateSubscriptionLevelStateToActivate - Update the alert's state
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// ascLocation - The location where ASC stores the data of the subscription. can be retrieved from Get locations
// alertName - Name of the alert object
// options - AlertsClientUpdateSubscriptionLevelStateToActivateOptions contains the optional parameters for the AlertsClient.UpdateSubscriptionLevelStateToActivate
// method.
func (client *AlertsClient) UpdateSubscriptionLevelStateToActivate(ctx context.Context, ascLocation string, alertName string, options *AlertsClientUpdateSubscriptionLevelStateToActivateOptions) (AlertsClientUpdateSubscriptionLevelStateToActivateResponse, error) {
	req, err := client.updateSubscriptionLevelStateToActivateCreateRequest(ctx, ascLocation, alertName, options)
	if err != nil {
		return AlertsClientUpdateSubscriptionLevelStateToActivateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AlertsClientUpdateSubscriptionLevelStateToActivateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return AlertsClientUpdateSubscriptionLevelStateToActivateResponse{}, runtime.NewResponseError(resp)
	}
	return AlertsClientUpdateSubscriptionLevelStateToActivateResponse{}, nil
}

// updateSubscriptionLevelStateToActivateCreateRequest creates the UpdateSubscriptionLevelStateToActivate request.
func (client *AlertsClient) updateSubscriptionLevelStateToActivateCreateRequest(ctx context.Context, ascLocation string, alertName string, options *AlertsClientUpdateSubscriptionLevelStateToActivateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/activate"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if ascLocation == "" {
		return nil, errors.New("parameter ascLocation cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ascLocation}", url.PathEscape(ascLocation))
	if alertName == "" {
		return nil, errors.New("parameter alertName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertName}", url.PathEscape(alertName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// UpdateSubscriptionLevelStateToDismiss - Update the alert's state
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// ascLocation - The location where ASC stores the data of the subscription. can be retrieved from Get locations
// alertName - Name of the alert object
// options - AlertsClientUpdateSubscriptionLevelStateToDismissOptions contains the optional parameters for the AlertsClient.UpdateSubscriptionLevelStateToDismiss
// method.
func (client *AlertsClient) UpdateSubscriptionLevelStateToDismiss(ctx context.Context, ascLocation string, alertName string, options *AlertsClientUpdateSubscriptionLevelStateToDismissOptions) (AlertsClientUpdateSubscriptionLevelStateToDismissResponse, error) {
	req, err := client.updateSubscriptionLevelStateToDismissCreateRequest(ctx, ascLocation, alertName, options)
	if err != nil {
		return AlertsClientUpdateSubscriptionLevelStateToDismissResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AlertsClientUpdateSubscriptionLevelStateToDismissResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return AlertsClientUpdateSubscriptionLevelStateToDismissResponse{}, runtime.NewResponseError(resp)
	}
	return AlertsClientUpdateSubscriptionLevelStateToDismissResponse{}, nil
}

// updateSubscriptionLevelStateToDismissCreateRequest creates the UpdateSubscriptionLevelStateToDismiss request.
func (client *AlertsClient) updateSubscriptionLevelStateToDismissCreateRequest(ctx context.Context, ascLocation string, alertName string, options *AlertsClientUpdateSubscriptionLevelStateToDismissOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/dismiss"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if ascLocation == "" {
		return nil, errors.New("parameter ascLocation cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ascLocation}", url.PathEscape(ascLocation))
	if alertName == "" {
		return nil, errors.New("parameter alertName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertName}", url.PathEscape(alertName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// UpdateSubscriptionLevelStateToInProgress - Update the alert's state
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// ascLocation - The location where ASC stores the data of the subscription. can be retrieved from Get locations
// alertName - Name of the alert object
// options - AlertsClientUpdateSubscriptionLevelStateToInProgressOptions contains the optional parameters for the AlertsClient.UpdateSubscriptionLevelStateToInProgress
// method.
func (client *AlertsClient) UpdateSubscriptionLevelStateToInProgress(ctx context.Context, ascLocation string, alertName string, options *AlertsClientUpdateSubscriptionLevelStateToInProgressOptions) (AlertsClientUpdateSubscriptionLevelStateToInProgressResponse, error) {
	req, err := client.updateSubscriptionLevelStateToInProgressCreateRequest(ctx, ascLocation, alertName, options)
	if err != nil {
		return AlertsClientUpdateSubscriptionLevelStateToInProgressResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AlertsClientUpdateSubscriptionLevelStateToInProgressResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return AlertsClientUpdateSubscriptionLevelStateToInProgressResponse{}, runtime.NewResponseError(resp)
	}
	return AlertsClientUpdateSubscriptionLevelStateToInProgressResponse{}, nil
}

// updateSubscriptionLevelStateToInProgressCreateRequest creates the UpdateSubscriptionLevelStateToInProgress request.
func (client *AlertsClient) updateSubscriptionLevelStateToInProgressCreateRequest(ctx context.Context, ascLocation string, alertName string, options *AlertsClientUpdateSubscriptionLevelStateToInProgressOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/inProgress"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if ascLocation == "" {
		return nil, errors.New("parameter ascLocation cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ascLocation}", url.PathEscape(ascLocation))
	if alertName == "" {
		return nil, errors.New("parameter alertName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertName}", url.PathEscape(alertName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// UpdateSubscriptionLevelStateToResolve - Update the alert's state
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// ascLocation - The location where ASC stores the data of the subscription. can be retrieved from Get locations
// alertName - Name of the alert object
// options - AlertsClientUpdateSubscriptionLevelStateToResolveOptions contains the optional parameters for the AlertsClient.UpdateSubscriptionLevelStateToResolve
// method.
func (client *AlertsClient) UpdateSubscriptionLevelStateToResolve(ctx context.Context, ascLocation string, alertName string, options *AlertsClientUpdateSubscriptionLevelStateToResolveOptions) (AlertsClientUpdateSubscriptionLevelStateToResolveResponse, error) {
	req, err := client.updateSubscriptionLevelStateToResolveCreateRequest(ctx, ascLocation, alertName, options)
	if err != nil {
		return AlertsClientUpdateSubscriptionLevelStateToResolveResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AlertsClientUpdateSubscriptionLevelStateToResolveResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return AlertsClientUpdateSubscriptionLevelStateToResolveResponse{}, runtime.NewResponseError(resp)
	}
	return AlertsClientUpdateSubscriptionLevelStateToResolveResponse{}, nil
}

// updateSubscriptionLevelStateToResolveCreateRequest creates the UpdateSubscriptionLevelStateToResolve request.
func (client *AlertsClient) updateSubscriptionLevelStateToResolveCreateRequest(ctx context.Context, ascLocation string, alertName string, options *AlertsClientUpdateSubscriptionLevelStateToResolveOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/resolve"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if ascLocation == "" {
		return nil, errors.New("parameter ascLocation cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ascLocation}", url.PathEscape(ascLocation))
	if alertName == "" {
		return nil, errors.New("parameter alertName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertName}", url.PathEscape(alertName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
