// Code generated by smithy-go-codegen DO NOT EDIT.

package configservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/configservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates and updates the configuration aggregator with the selected source
// accounts and regions. The source account can be individual account(s) or an
// organization.
//
// accountIds that are passed will be replaced with existing accounts. If you want
// to add additional accounts into the aggregator, call
// DescribeConfigurationAggregators to get the previous accounts and then append
// new ones.
//
// Config should be enabled in source accounts and regions you want to aggregate.
//
// If your source type is an organization, you must be signed in to the management
// account or a registered delegated administrator and all the features must be
// enabled in your organization. If the caller is a management account, Config
// calls EnableAwsServiceAccess API to enable integration between Config and
// Organizations. If the caller is a registered delegated administrator, Config
// calls ListDelegatedAdministrators API to verify whether the caller is a valid
// delegated administrator.
//
// To register a delegated administrator, see [Register a Delegated Administrator] in the Config developer guide.
//
// PutConfigurationAggregator is an idempotent API. Subsequent requests won’t
// create a duplicate resource if one was already created. If a following request
// has different tags values, Config will ignore these differences and treat it as
// an idempotent request of the previous. In this case, tags will not be updated,
// even if they are different.
//
// [Register a Delegated Administrator]: https://docs.aws.amazon.com/config/latest/developerguide/set-up-aggregator-cli.html#register-a-delegated-administrator-cli
func (c *Client) PutConfigurationAggregator(ctx context.Context, params *PutConfigurationAggregatorInput, optFns ...func(*Options)) (*PutConfigurationAggregatorOutput, error) {
	if params == nil {
		params = &PutConfigurationAggregatorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutConfigurationAggregator", params, optFns, c.addOperationPutConfigurationAggregatorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutConfigurationAggregatorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutConfigurationAggregatorInput struct {

	// The name of the configuration aggregator.
	//
	// This member is required.
	ConfigurationAggregatorName *string

	// A list of AccountAggregationSource object.
	AccountAggregationSources []types.AccountAggregationSource

	// An OrganizationAggregationSource object.
	OrganizationAggregationSource *types.OrganizationAggregationSource

	// An array of tag object.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type PutConfigurationAggregatorOutput struct {

	// Returns a ConfigurationAggregator object.
	ConfigurationAggregator *types.ConfigurationAggregator

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutConfigurationAggregatorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpPutConfigurationAggregator{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpPutConfigurationAggregator{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutConfigurationAggregator"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPutConfigurationAggregatorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutConfigurationAggregator(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutConfigurationAggregator(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutConfigurationAggregator",
	}
}
