// Code generated by smithy-go-codegen DO NOT EDIT.

package drs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/drs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deploy VPC for the specified Source Network and modify launch templates to use
// this network. The VPC will be deployed using a dedicated CloudFormation stack.
func (c *Client) StartSourceNetworkRecovery(ctx context.Context, params *StartSourceNetworkRecoveryInput, optFns ...func(*Options)) (*StartSourceNetworkRecoveryOutput, error) {
	if params == nil {
		params = &StartSourceNetworkRecoveryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartSourceNetworkRecovery", params, optFns, c.addOperationStartSourceNetworkRecoveryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartSourceNetworkRecoveryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartSourceNetworkRecoveryInput struct {

	// The Source Networks that we want to start a Recovery Job for.
	//
	// This member is required.
	SourceNetworks []types.StartSourceNetworkRecoveryRequestNetworkEntry

	// Don't update existing CloudFormation Stack, recover the network using a new
	// stack.
	DeployAsNew *bool

	// The tags to be associated with the Source Network recovery Job.
	Tags map[string]string

	noSmithyDocumentSerde
}

type StartSourceNetworkRecoveryOutput struct {

	// The Source Network recovery Job.
	Job *types.Job

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartSourceNetworkRecoveryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartSourceNetworkRecovery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartSourceNetworkRecovery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartSourceNetworkRecovery"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartSourceNetworkRecoveryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartSourceNetworkRecovery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartSourceNetworkRecovery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartSourceNetworkRecovery",
	}
}
