// Code generated by smithy-go-codegen DO NOT EDIT.

package swf

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/swf/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Used by deciders to tell the service that the DecisionTask identified by the taskToken has
// successfully completed. The decisions argument specifies the list of decisions
// made while processing the task.
//
// A DecisionTaskCompleted event is added to the workflow history. The
// executionContext specified is attached to the event in the workflow execution
// history.
//
// # Access Control
//
// If an IAM policy grants permission to use RespondDecisionTaskCompleted , it can
// express permissions for the list of decisions in the decisions parameter. Each
// of the decisions has one or more parameters, much like a regular API call. To
// allow for policies to be as readable as possible, you can express permissions on
// decisions as if they were actual API calls, including applying conditions to
// some parameters. For more information, see [Using IAM to Manage Access to Amazon SWF Workflows]in the Amazon SWF Developer Guide.
//
// [Using IAM to Manage Access to Amazon SWF Workflows]: https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html
func (c *Client) RespondDecisionTaskCompleted(ctx context.Context, params *RespondDecisionTaskCompletedInput, optFns ...func(*Options)) (*RespondDecisionTaskCompletedOutput, error) {
	if params == nil {
		params = &RespondDecisionTaskCompletedInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RespondDecisionTaskCompleted", params, optFns, c.addOperationRespondDecisionTaskCompletedMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RespondDecisionTaskCompletedOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Input data for a TaskCompleted response to a decision task.
type RespondDecisionTaskCompletedInput struct {

	// The taskToken from the DecisionTask.
	//
	// taskToken is generated by the service and should be treated as an opaque value.
	// If the task is passed to another process, its taskToken must also be passed.
	// This enables it to provide its progress and respond with results.
	//
	// This member is required.
	TaskToken *string

	// The list of decisions (possibly empty) made by the decider while processing
	// this decision task. See the docs for the Decisionstructure for details.
	Decisions []types.Decision

	// User defined context to add to workflow execution.
	ExecutionContext *string

	// The task list to use for the future decision tasks of this workflow execution.
	// This list overrides the original task list you specified while starting the
	// workflow execution.
	TaskList *types.TaskList

	// Specifies a timeout (in seconds) for the task list override. When this
	// parameter is missing, the task list override is permanent. This parameter makes
	// it possible to temporarily override the task list. If a decision task scheduled
	// on the override task list is not started within the timeout, the decision task
	// will time out. Amazon SWF will revert the override and schedule a new decision
	// task to the original task list.
	//
	// If a decision task scheduled on the override task list is started within the
	// timeout, but not completed within the start-to-close timeout, Amazon SWF will
	// also revert the override and schedule a new decision task to the original task
	// list.
	TaskListScheduleToStartTimeout *string

	noSmithyDocumentSerde
}

type RespondDecisionTaskCompletedOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRespondDecisionTaskCompletedMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpRespondDecisionTaskCompleted{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpRespondDecisionTaskCompleted{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RespondDecisionTaskCompleted"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpRespondDecisionTaskCompletedValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRespondDecisionTaskCompleted(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRespondDecisionTaskCompleted(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RespondDecisionTaskCompleted",
	}
}
