# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPIConnectedEnvironmentsDaprComponentsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.connected_environments_dapr_components.list(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            api_version="2024-08-02-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.connected_environments_dapr_components.get(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            component_name="str",
            api_version="2024-08-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create_or_update(self, resource_group):
        response = self.client.connected_environments_dapr_components.create_or_update(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            component_name="str",
            dapr_component_envelope={
                "componentType": "str",
                "id": "str",
                "ignoreErrors": False,
                "initTimeout": "str",
                "metadata": [{"name": "str", "secretRef": "str", "value": "str"}],
                "name": "str",
                "scopes": ["str"],
                "secretStoreComponent": "str",
                "secrets": [{"identity": "str", "keyVaultUrl": "str", "name": "str", "value": "str"}],
                "serviceComponentBind": [
                    {"metadata": {"name": "str", "value": "str"}, "name": "str", "serviceId": "str"}
                ],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
                "version": "str",
            },
            api_version="2024-08-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete(self, resource_group):
        response = self.client.connected_environments_dapr_components.delete(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            component_name="str",
            api_version="2024-08-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_secrets(self, resource_group):
        response = self.client.connected_environments_dapr_components.list_secrets(
            resource_group_name=resource_group.name,
            connected_environment_name="str",
            component_name="str",
            api_version="2024-08-02-preview",
        )

        # please add some check logic here by yourself
        # ...
