# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ResponseBase(Model):
    """Response base.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Identifiable

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Identifiable': 'Identifiable'}
    }

    def __init__(self, **kwargs):
        super(ResponseBase, self).__init__(**kwargs)
        self._type = None


class Identifiable(ResponseBase):
    """Defines the identity of a resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Response

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Response': 'Response'}
    }

    def __init__(self, **kwargs):
        super(Identifiable, self).__init__(**kwargs)
        self.id = None
        self._type = 'Identifiable'


class Response(Identifiable):
    """Defines a response. All schemas that could be returned at the root of a
    response should inherit from this.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Answer, Thing, ErrorResponse, RecognizedEntity,
    RecognizedEntityRegion, ImageInsights, TrendingImages

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Answer': 'Answer', 'Thing': 'Thing', 'ErrorResponse': 'ErrorResponse', 'RecognizedEntity': 'RecognizedEntity', 'RecognizedEntityRegion': 'RecognizedEntityRegion', 'ImageInsights': 'ImageInsights', 'TrendingImages': 'TrendingImages'}
    }

    def __init__(self, **kwargs):
        super(Response, self).__init__(**kwargs)
        self.read_link = None
        self.web_search_url = None
        self._type = 'Response'


class Thing(Response):
    """Defines a thing.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Organization, Offer, CreativeWork, Person, Intangible

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Organization': 'Organization', 'Offer': 'Offer', 'CreativeWork': 'CreativeWork', 'Person': 'Person', 'Intangible': 'Intangible'}
    }

    def __init__(self, **kwargs):
        super(Thing, self).__init__(**kwargs)
        self.name = None
        self.url = None
        self.image = None
        self.description = None
        self.alternate_name = None
        self.bing_id = None
        self._type = 'Thing'


class Offer(Thing):
    """Defines a merchant's offer.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AggregateOffer

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar seller: Seller for this offer
    :vartype seller:
     ~azure.cognitiveservices.search.imagesearch.models.Organization
    :ivar price: The item's price.
    :vartype price: float
    :ivar price_currency: The monetary currency. For example, USD. Possible
     values include: 'USD', 'CAD', 'GBP', 'EUR', 'COP', 'JPY', 'CNY', 'AUD',
     'INR', 'AED', 'AFN', 'ALL', 'AMD', 'ANG', 'AOA', 'ARS', 'AWG', 'AZN',
     'BAM', 'BBD', 'BDT', 'BGN', 'BHD', 'BIF', 'BMD', 'BND', 'BOB', 'BOV',
     'BRL', 'BSD', 'BTN', 'BWP', 'BYR', 'BZD', 'CDF', 'CHE', 'CHF', 'CHW',
     'CLF', 'CLP', 'COU', 'CRC', 'CUC', 'CUP', 'CVE', 'CZK', 'DJF', 'DKK',
     'DOP', 'DZD', 'EGP', 'ERN', 'ETB', 'FJD', 'FKP', 'GEL', 'GHS', 'GIP',
     'GMD', 'GNF', 'GTQ', 'GYD', 'HKD', 'HNL', 'HRK', 'HTG', 'HUF', 'IDR',
     'ILS', 'IQD', 'IRR', 'ISK', 'JMD', 'JOD', 'KES', 'KGS', 'KHR', 'KMF',
     'KPW', 'KRW', 'KWD', 'KYD', 'KZT', 'LAK', 'LBP', 'LKR', 'LRD', 'LSL',
     'LYD', 'MAD', 'MDL', 'MGA', 'MKD', 'MMK', 'MNT', 'MOP', 'MRO', 'MUR',
     'MVR', 'MWK', 'MXN', 'MXV', 'MYR', 'MZN', 'NAD', 'NGN', 'NIO', 'NOK',
     'NPR', 'NZD', 'OMR', 'PAB', 'PEN', 'PGK', 'PHP', 'PKR', 'PLN', 'PYG',
     'QAR', 'RON', 'RSD', 'RUB', 'RWF', 'SAR', 'SBD', 'SCR', 'SDG', 'SEK',
     'SGD', 'SHP', 'SLL', 'SOS', 'SRD', 'SSP', 'STD', 'SYP', 'SZL', 'THB',
     'TJS', 'TMT', 'TND', 'TOP', 'TRY', 'TTD', 'TWD', 'TZS', 'UAH', 'UGX',
     'UYU', 'UZS', 'VEF', 'VND', 'VUV', 'WST', 'XAF', 'XCD', 'XOF', 'XPF',
     'YER', 'ZAR', 'ZMW'. Default value: "USD" .
    :vartype price_currency: str or
     ~azure.cognitiveservices.search.imagesearch.models.Currency
    :ivar availability: The item's availability. The following are the
     possible values: Discontinued, InStock, InStoreOnly, LimitedAvailability,
     OnlineOnly, OutOfStock, PreOrder, SoldOut. Possible values include:
     'Discontinued', 'InStock', 'InStoreOnly', 'LimitedAvailability',
     'OnlineOnly', 'OutOfStock', 'PreOrder', 'SoldOut'
    :vartype availability: str or
     ~azure.cognitiveservices.search.imagesearch.models.ItemAvailability
    :ivar aggregate_rating: An aggregated rating that indicates how well the
     product has been rated by others.
    :vartype aggregate_rating:
     ~azure.cognitiveservices.search.imagesearch.models.AggregateRating
    :ivar last_updated: The last date that the offer was updated. The date is
     in the form YYYY-MM-DD.
    :vartype last_updated: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'seller': {'readonly': True},
        'price': {'readonly': True},
        'price_currency': {'readonly': True},
        'availability': {'readonly': True},
        'aggregate_rating': {'readonly': True},
        'last_updated': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'seller': {'key': 'seller', 'type': 'Organization'},
        'price': {'key': 'price', 'type': 'float'},
        'price_currency': {'key': 'priceCurrency', 'type': 'str'},
        'availability': {'key': 'availability', 'type': 'str'},
        'aggregate_rating': {'key': 'aggregateRating', 'type': 'AggregateRating'},
        'last_updated': {'key': 'lastUpdated', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'AggregateOffer': 'AggregateOffer'}
    }

    def __init__(self, **kwargs):
        super(Offer, self).__init__(**kwargs)
        self.seller = None
        self.price = None
        self.price_currency = None
        self.availability = None
        self.aggregate_rating = None
        self.last_updated = None
        self._type = 'Offer'


class AggregateOffer(Offer):
    """Defines a list of offers from merchants that are related to the image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar seller: Seller for this offer
    :vartype seller:
     ~azure.cognitiveservices.search.imagesearch.models.Organization
    :ivar price: The item's price.
    :vartype price: float
    :ivar price_currency: The monetary currency. For example, USD. Possible
     values include: 'USD', 'CAD', 'GBP', 'EUR', 'COP', 'JPY', 'CNY', 'AUD',
     'INR', 'AED', 'AFN', 'ALL', 'AMD', 'ANG', 'AOA', 'ARS', 'AWG', 'AZN',
     'BAM', 'BBD', 'BDT', 'BGN', 'BHD', 'BIF', 'BMD', 'BND', 'BOB', 'BOV',
     'BRL', 'BSD', 'BTN', 'BWP', 'BYR', 'BZD', 'CDF', 'CHE', 'CHF', 'CHW',
     'CLF', 'CLP', 'COU', 'CRC', 'CUC', 'CUP', 'CVE', 'CZK', 'DJF', 'DKK',
     'DOP', 'DZD', 'EGP', 'ERN', 'ETB', 'FJD', 'FKP', 'GEL', 'GHS', 'GIP',
     'GMD', 'GNF', 'GTQ', 'GYD', 'HKD', 'HNL', 'HRK', 'HTG', 'HUF', 'IDR',
     'ILS', 'IQD', 'IRR', 'ISK', 'JMD', 'JOD', 'KES', 'KGS', 'KHR', 'KMF',
     'KPW', 'KRW', 'KWD', 'KYD', 'KZT', 'LAK', 'LBP', 'LKR', 'LRD', 'LSL',
     'LYD', 'MAD', 'MDL', 'MGA', 'MKD', 'MMK', 'MNT', 'MOP', 'MRO', 'MUR',
     'MVR', 'MWK', 'MXN', 'MXV', 'MYR', 'MZN', 'NAD', 'NGN', 'NIO', 'NOK',
     'NPR', 'NZD', 'OMR', 'PAB', 'PEN', 'PGK', 'PHP', 'PKR', 'PLN', 'PYG',
     'QAR', 'RON', 'RSD', 'RUB', 'RWF', 'SAR', 'SBD', 'SCR', 'SDG', 'SEK',
     'SGD', 'SHP', 'SLL', 'SOS', 'SRD', 'SSP', 'STD', 'SYP', 'SZL', 'THB',
     'TJS', 'TMT', 'TND', 'TOP', 'TRY', 'TTD', 'TWD', 'TZS', 'UAH', 'UGX',
     'UYU', 'UZS', 'VEF', 'VND', 'VUV', 'WST', 'XAF', 'XCD', 'XOF', 'XPF',
     'YER', 'ZAR', 'ZMW'. Default value: "USD" .
    :vartype price_currency: str or
     ~azure.cognitiveservices.search.imagesearch.models.Currency
    :ivar availability: The item's availability. The following are the
     possible values: Discontinued, InStock, InStoreOnly, LimitedAvailability,
     OnlineOnly, OutOfStock, PreOrder, SoldOut. Possible values include:
     'Discontinued', 'InStock', 'InStoreOnly', 'LimitedAvailability',
     'OnlineOnly', 'OutOfStock', 'PreOrder', 'SoldOut'
    :vartype availability: str or
     ~azure.cognitiveservices.search.imagesearch.models.ItemAvailability
    :ivar aggregate_rating: An aggregated rating that indicates how well the
     product has been rated by others.
    :vartype aggregate_rating:
     ~azure.cognitiveservices.search.imagesearch.models.AggregateRating
    :ivar last_updated: The last date that the offer was updated. The date is
     in the form YYYY-MM-DD.
    :vartype last_updated: str
    :ivar offers: A list of offers from merchants that have offerings related
     to the image.
    :vartype offers:
     list[~azure.cognitiveservices.search.imagesearch.models.Offer]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'seller': {'readonly': True},
        'price': {'readonly': True},
        'price_currency': {'readonly': True},
        'availability': {'readonly': True},
        'aggregate_rating': {'readonly': True},
        'last_updated': {'readonly': True},
        'offers': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'seller': {'key': 'seller', 'type': 'Organization'},
        'price': {'key': 'price', 'type': 'float'},
        'price_currency': {'key': 'priceCurrency', 'type': 'str'},
        'availability': {'key': 'availability', 'type': 'str'},
        'aggregate_rating': {'key': 'aggregateRating', 'type': 'AggregateRating'},
        'last_updated': {'key': 'lastUpdated', 'type': 'str'},
        'offers': {'key': 'offers', 'type': '[Offer]'},
    }

    def __init__(self, **kwargs):
        super(AggregateOffer, self).__init__(**kwargs)
        self.offers = None
        self._type = 'AggregateOffer'


class PropertiesItem(Model):
    """Defines an item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Rating

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Text representation of an item.
    :vartype text: str
    :param _type: Required. Constant filled by server.
    :type _type: str
    """

    _validation = {
        'text': {'readonly': True},
        '_type': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        '_type': {'key': '_type', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Rating': 'Rating'}
    }

    def __init__(self, **kwargs):
        super(PropertiesItem, self).__init__(**kwargs)
        self.text = None
        self._type = None


class Rating(PropertiesItem):
    """Defines a rating.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AggregateRating

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Text representation of an item.
    :vartype text: str
    :param _type: Required. Constant filled by server.
    :type _type: str
    :param rating_value: Required. The mean (average) rating. The possible
     values are 1.0 through 5.0.
    :type rating_value: float
    :ivar best_rating: The highest rated review. The possible values are 1.0
     through 5.0.
    :vartype best_rating: float
    """

    _validation = {
        'text': {'readonly': True},
        '_type': {'required': True},
        'rating_value': {'required': True},
        'best_rating': {'readonly': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        '_type': {'key': '_type', 'type': 'str'},
        'rating_value': {'key': 'ratingValue', 'type': 'float'},
        'best_rating': {'key': 'bestRating', 'type': 'float'},
    }

    _subtype_map = {
        '_type': {'AggregateRating': 'AggregateRating'}
    }

    def __init__(self, **kwargs):
        super(Rating, self).__init__(**kwargs)
        self.rating_value = kwargs.get('rating_value', None)
        self.best_rating = None
        self._type = 'Rating'


class AggregateRating(Rating):
    """Defines the metrics that indicate how well an item was rated by others.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Text representation of an item.
    :vartype text: str
    :param _type: Required. Constant filled by server.
    :type _type: str
    :param rating_value: Required. The mean (average) rating. The possible
     values are 1.0 through 5.0.
    :type rating_value: float
    :ivar best_rating: The highest rated review. The possible values are 1.0
     through 5.0.
    :vartype best_rating: float
    :ivar review_count: The number of times the recipe has been rated or
     reviewed.
    :vartype review_count: int
    """

    _validation = {
        'text': {'readonly': True},
        '_type': {'required': True},
        'rating_value': {'required': True},
        'best_rating': {'readonly': True},
        'review_count': {'readonly': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        '_type': {'key': '_type', 'type': 'str'},
        'rating_value': {'key': 'ratingValue', 'type': 'float'},
        'best_rating': {'key': 'bestRating', 'type': 'float'},
        'review_count': {'key': 'reviewCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AggregateRating, self).__init__(**kwargs)
        self.review_count = None
        self._type = 'AggregateRating'


class Answer(Response):
    """Defines an answer.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SearchResultsAnswer

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'SearchResultsAnswer': 'SearchResultsAnswer'}
    }

    def __init__(self, **kwargs):
        super(Answer, self).__init__(**kwargs)
        self._type = 'Answer'


class CreativeWork(Thing):
    """The most generic kind of creative work, including books, movies,
    photographs, software programs, etc.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MediaObject, Recipe, WebPage

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.imagesearch.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work
    :vartype text: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'MediaObject': 'MediaObject', 'Recipe': 'Recipe', 'WebPage': 'WebPage'}
    }

    def __init__(self, **kwargs):
        super(CreativeWork, self).__init__(**kwargs)
        self.thumbnail_url = None
        self.provider = None
        self.date_published = None
        self.text = None
        self._type = 'CreativeWork'


class WebPage(CreativeWork):
    """Defines a webpage that is relevant to the query.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CollectionPage

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.imagesearch.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work
    :vartype text: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'CollectionPage': 'CollectionPage'}
    }

    def __init__(self, **kwargs):
        super(WebPage, self).__init__(**kwargs)
        self._type = 'WebPage'


class CollectionPage(WebPage):
    """Defines a link to a webpage that contains a collection.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ImageGallery

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.imagesearch.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work
    :vartype text: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'ImageGallery': 'ImageGallery'}
    }

    def __init__(self, **kwargs):
        super(CollectionPage, self).__init__(**kwargs)
        self._type = 'CollectionPage'


class Error(Model):
    """Defines the error that occurred.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error code that identifies the category of
     error. Possible values include: 'None', 'ServerError', 'InvalidRequest',
     'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'.
     Default value: "None" .
    :type code: str or
     ~azure.cognitiveservices.search.imagesearch.models.ErrorCode
    :ivar sub_code: The error code that further helps to identify the error.
     Possible values include: 'UnexpectedError', 'ResourceError',
     'NotImplemented', 'ParameterMissing', 'ParameterInvalidValue',
     'HttpNotAllowed', 'Blocked', 'AuthorizationMissing',
     'AuthorizationRedundancy', 'AuthorizationDisabled', 'AuthorizationExpired'
    :vartype sub_code: str or
     ~azure.cognitiveservices.search.imagesearch.models.ErrorSubCode
    :param message: Required. A description of the error.
    :type message: str
    :ivar more_details: A description that provides additional information
     about the error.
    :vartype more_details: str
    :ivar parameter: The parameter in the request that caused the error.
    :vartype parameter: str
    :ivar value: The parameter's value in the request that was not valid.
    :vartype value: str
    """

    _validation = {
        'code': {'required': True},
        'sub_code': {'readonly': True},
        'message': {'required': True},
        'more_details': {'readonly': True},
        'parameter': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'sub_code': {'key': 'subCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'more_details': {'key': 'moreDetails', 'type': 'str'},
        'parameter': {'key': 'parameter', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', "None")
        self.sub_code = None
        self.message = kwargs.get('message', None)
        self.more_details = None
        self.parameter = None
        self.value = None


class ErrorResponse(Response):
    """The top-level response that represents a failed request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :param errors: Required. A list of errors that describe the reasons why
     the request failed.
    :type errors:
     list[~azure.cognitiveservices.search.imagesearch.models.Error]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'errors': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[Error]'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.errors = kwargs.get('errors', None)
        self._type = 'ErrorResponse'


class ErrorResponseException(HttpOperationError):
    """Server responded with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class ImageGallery(CollectionPage):
    """Defines a link to a webpage that contains a collection of related images.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.imagesearch.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work
    :vartype text: str
    :ivar source: The publisher or social network where the images were found.
     You must attribute the publisher as the source where the collection was
     found.
    :vartype source: str
    :ivar images_count: The number of related images found in the collection.
    :vartype images_count: long
    :ivar followers_count: The number of users on the social network that
     follow the creator.
    :vartype followers_count: long
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'source': {'readonly': True},
        'images_count': {'readonly': True},
        'followers_count': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'images_count': {'key': 'imagesCount', 'type': 'long'},
        'followers_count': {'key': 'followersCount', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(ImageGallery, self).__init__(**kwargs)
        self.source = None
        self.images_count = None
        self.followers_count = None
        self._type = 'ImageGallery'


class ImageInsights(Response):
    """The top-level object that the response includes when an image insights
    request succeeds. For information about requesting image insights, see the
    [insightsToken](https://docs.microsoft.com/en-us/rest/api/cognitiveservices/bing-images-api-v7-reference#insightstoken)
    query parameter. The modules query parameter affects the fields that Bing
    includes in the response. If you set
    [modules](https://docs.microsoft.com/en-us/rest/api/cognitiveservices/bing-images-api-v7-reference#modulesrequested)
    to only Caption, then this object includes only the imageCaption field.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar image_insights_token: A token that you use in a subsequent call to
     the Image Search API to get more information about the image. For
     information about using this token, see the insightsToken query parameter.
     This token has the same usage as the token in the Image object.
    :vartype image_insights_token: str
    :ivar best_representative_query: The query term that best represents the
     image. Clicking the link in the Query object, takes the user to a webpage
     with more pictures of the image.
    :vartype best_representative_query:
     ~azure.cognitiveservices.search.imagesearch.models.Query
    :ivar image_caption: The caption to use for the image.
    :vartype image_caption:
     ~azure.cognitiveservices.search.imagesearch.models.ImageInsightsImageCaption
    :ivar related_collections: A list of links to webpages that contain
     related images.
    :vartype related_collections:
     ~azure.cognitiveservices.search.imagesearch.models.RelatedCollectionsModule
    :ivar pages_including: A list of webpages that contain the image. To
     access the webpage, use the URL in the image's hostPageUrl field.
    :vartype pages_including:
     ~azure.cognitiveservices.search.imagesearch.models.ImagesModule
    :ivar shopping_sources: A list of merchants that offer items related to
     the image. For example, if the image is of an apple pie, the list contains
     merchants that are selling apple pies.
    :vartype shopping_sources:
     ~azure.cognitiveservices.search.imagesearch.models.AggregateOffer
    :ivar related_searches: A list of related queries made by others.
    :vartype related_searches:
     ~azure.cognitiveservices.search.imagesearch.models.RelatedSearchesModule
    :ivar recipes: A list of recipes related to the image. For example, if the
     image is of an apple pie, the list contains recipes for making an apple
     pie.
    :vartype recipes:
     ~azure.cognitiveservices.search.imagesearch.models.RecipesModule
    :ivar visually_similar_images: A list of images that are visually similar
     to the original image. For example, if the specified image is of a sunset
     over a body of water, the list of similar images are of a sunset over a
     body of water. If the specified image is of a person, similar images might
     be of the same person or they might be of persons dressed similarly or in
     a similar setting. The criteria for similarity continues to evolve.
    :vartype visually_similar_images:
     ~azure.cognitiveservices.search.imagesearch.models.ImagesModule
    :ivar visually_similar_products: A list of images that contain products
     that are visually similar to products found in the original image. For
     example, if the specified image contains a dress, the list of similar
     images contain a dress. The image provides summary information about
     offers that Bing found online for the product.
    :vartype visually_similar_products:
     ~azure.cognitiveservices.search.imagesearch.models.ImagesModule
    :ivar recognized_entity_groups: A list of groups that contain images of
     entities that match the entity found in the specified image. For example,
     the response might include images from the general celebrity group if the
     entity was recognized in that group.
    :vartype recognized_entity_groups:
     ~azure.cognitiveservices.search.imagesearch.models.RecognizedEntitiesModule
    :ivar image_tags: A list of characteristics of the content found in the
     image. For example, if the image is of a person, the tags might indicate
     the person's gender and the type of clothes they're wearing.
    :vartype image_tags:
     ~azure.cognitiveservices.search.imagesearch.models.ImageTagsModule
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'image_insights_token': {'readonly': True},
        'best_representative_query': {'readonly': True},
        'image_caption': {'readonly': True},
        'related_collections': {'readonly': True},
        'pages_including': {'readonly': True},
        'shopping_sources': {'readonly': True},
        'related_searches': {'readonly': True},
        'recipes': {'readonly': True},
        'visually_similar_images': {'readonly': True},
        'visually_similar_products': {'readonly': True},
        'recognized_entity_groups': {'readonly': True},
        'image_tags': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'image_insights_token': {'key': 'imageInsightsToken', 'type': 'str'},
        'best_representative_query': {'key': 'bestRepresentativeQuery', 'type': 'Query'},
        'image_caption': {'key': 'imageCaption', 'type': 'ImageInsightsImageCaption'},
        'related_collections': {'key': 'relatedCollections', 'type': 'RelatedCollectionsModule'},
        'pages_including': {'key': 'pagesIncluding', 'type': 'ImagesModule'},
        'shopping_sources': {'key': 'shoppingSources', 'type': 'AggregateOffer'},
        'related_searches': {'key': 'relatedSearches', 'type': 'RelatedSearchesModule'},
        'recipes': {'key': 'recipes', 'type': 'RecipesModule'},
        'visually_similar_images': {'key': 'visuallySimilarImages', 'type': 'ImagesModule'},
        'visually_similar_products': {'key': 'visuallySimilarProducts', 'type': 'ImagesModule'},
        'recognized_entity_groups': {'key': 'recognizedEntityGroups', 'type': 'RecognizedEntitiesModule'},
        'image_tags': {'key': 'imageTags', 'type': 'ImageTagsModule'},
    }

    def __init__(self, **kwargs):
        super(ImageInsights, self).__init__(**kwargs)
        self.image_insights_token = None
        self.best_representative_query = None
        self.image_caption = None
        self.related_collections = None
        self.pages_including = None
        self.shopping_sources = None
        self.related_searches = None
        self.recipes = None
        self.visually_similar_images = None
        self.visually_similar_products = None
        self.recognized_entity_groups = None
        self.image_tags = None
        self._type = 'ImageInsights'


class ImageInsightsImageCaption(Model):
    """Defines an image's caption.

    All required parameters must be populated in order to send to Azure.

    :param caption: Required. A caption about the image.
    :type caption: str
    :param data_source_url: Required. The URL to the website where the caption
     was found. You must attribute the caption to the source. For example, by
     displaying the domain name from the URL next to the caption and using the
     URL to link to the source website.
    :type data_source_url: str
    :param related_searches: Required. A list of entities found in the
     caption. Use the contents of the Query object to find the entity in the
     caption and create a link. The link takes the user to images of the
     entity.
    :type related_searches:
     list[~azure.cognitiveservices.search.imagesearch.models.Query]
    """

    _validation = {
        'caption': {'required': True},
        'data_source_url': {'required': True},
        'related_searches': {'required': True},
    }

    _attribute_map = {
        'caption': {'key': 'caption', 'type': 'str'},
        'data_source_url': {'key': 'dataSourceUrl', 'type': 'str'},
        'related_searches': {'key': 'relatedSearches', 'type': '[Query]'},
    }

    def __init__(self, **kwargs):
        super(ImageInsightsImageCaption, self).__init__(**kwargs)
        self.caption = kwargs.get('caption', None)
        self.data_source_url = kwargs.get('data_source_url', None)
        self.related_searches = kwargs.get('related_searches', None)


class MediaObject(CreativeWork):
    """Defines a media object.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ImageObject

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.imagesearch.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work
    :vartype text: str
    :ivar content_url: Original URL to retrieve the source (file) for the
     media object (e.g the source URL for the image).
    :vartype content_url: str
    :ivar host_page_url: URL of the page that hosts the media object.
    :vartype host_page_url: str
    :ivar content_size: Size of the media object content (use format "value
     unit" e.g "1024 B").
    :vartype content_size: str
    :ivar encoding_format: Encoding format (e.g mp3, mp4, jpeg, etc).
    :vartype encoding_format: str
    :ivar host_page_display_url: Display URL of the page that hosts the media
     object.
    :vartype host_page_display_url: str
    :ivar width: The width of the source media object, in pixels.
    :vartype width: int
    :ivar height: The height of the source media object, in pixels.
    :vartype height: int
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'content_url': {'readonly': True},
        'host_page_url': {'readonly': True},
        'content_size': {'readonly': True},
        'encoding_format': {'readonly': True},
        'host_page_display_url': {'readonly': True},
        'width': {'readonly': True},
        'height': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'content_url': {'key': 'contentUrl', 'type': 'str'},
        'host_page_url': {'key': 'hostPageUrl', 'type': 'str'},
        'content_size': {'key': 'contentSize', 'type': 'str'},
        'encoding_format': {'key': 'encodingFormat', 'type': 'str'},
        'host_page_display_url': {'key': 'hostPageDisplayUrl', 'type': 'str'},
        'width': {'key': 'width', 'type': 'int'},
        'height': {'key': 'height', 'type': 'int'},
    }

    _subtype_map = {
        '_type': {'ImageObject': 'ImageObject'}
    }

    def __init__(self, **kwargs):
        super(MediaObject, self).__init__(**kwargs)
        self.content_url = None
        self.host_page_url = None
        self.content_size = None
        self.encoding_format = None
        self.host_page_display_url = None
        self.width = None
        self.height = None
        self._type = 'MediaObject'


class ImageObject(MediaObject):
    """Defines an image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.imagesearch.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work
    :vartype text: str
    :ivar content_url: Original URL to retrieve the source (file) for the
     media object (e.g the source URL for the image).
    :vartype content_url: str
    :ivar host_page_url: URL of the page that hosts the media object.
    :vartype host_page_url: str
    :ivar content_size: Size of the media object content (use format "value
     unit" e.g "1024 B").
    :vartype content_size: str
    :ivar encoding_format: Encoding format (e.g mp3, mp4, jpeg, etc).
    :vartype encoding_format: str
    :ivar host_page_display_url: Display URL of the page that hosts the media
     object.
    :vartype host_page_display_url: str
    :ivar width: The width of the source media object, in pixels.
    :vartype width: int
    :ivar height: The height of the source media object, in pixels.
    :vartype height: int
    :ivar thumbnail: The URL to a thumbnail of the image
    :vartype thumbnail:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar image_insights_token: The token that you use in a subsequent call to
     the Image Search API to get additional information about the image. For
     information about using this token, see the insightsToken query parameter.
    :vartype image_insights_token: str
    :ivar insights_metadata: A count of the number of websites where you can
     shop or perform other actions related to the image. For example, if the
     image is of an apple pie, this object includes a count of the number of
     websites where you can buy an apple pie. To indicate the number of offers
     in your UX, include badging such as a shopping cart icon that contains the
     count. When the user clicks on the icon, use imageInsightsToken to get the
     list of websites.
    :vartype insights_metadata:
     ~azure.cognitiveservices.search.imagesearch.models.ImagesImageMetadata
    :ivar image_id: Unique Id for the image
    :vartype image_id: str
    :ivar accent_color: A three-byte hexadecimal number that represents the
     color that dominates the image. Use the color as the temporary background
     in your client until the image is loaded.
    :vartype accent_color: str
    :ivar visual_words: Visual representation of the image. Used for getting
     more sizes
    :vartype visual_words: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'content_url': {'readonly': True},
        'host_page_url': {'readonly': True},
        'content_size': {'readonly': True},
        'encoding_format': {'readonly': True},
        'host_page_display_url': {'readonly': True},
        'width': {'readonly': True},
        'height': {'readonly': True},
        'thumbnail': {'readonly': True},
        'image_insights_token': {'readonly': True},
        'insights_metadata': {'readonly': True},
        'image_id': {'readonly': True},
        'accent_color': {'readonly': True},
        'visual_words': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'content_url': {'key': 'contentUrl', 'type': 'str'},
        'host_page_url': {'key': 'hostPageUrl', 'type': 'str'},
        'content_size': {'key': 'contentSize', 'type': 'str'},
        'encoding_format': {'key': 'encodingFormat', 'type': 'str'},
        'host_page_display_url': {'key': 'hostPageDisplayUrl', 'type': 'str'},
        'width': {'key': 'width', 'type': 'int'},
        'height': {'key': 'height', 'type': 'int'},
        'thumbnail': {'key': 'thumbnail', 'type': 'ImageObject'},
        'image_insights_token': {'key': 'imageInsightsToken', 'type': 'str'},
        'insights_metadata': {'key': 'insightsMetadata', 'type': 'ImagesImageMetadata'},
        'image_id': {'key': 'imageId', 'type': 'str'},
        'accent_color': {'key': 'accentColor', 'type': 'str'},
        'visual_words': {'key': 'visualWords', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ImageObject, self).__init__(**kwargs)
        self.thumbnail = None
        self.image_insights_token = None
        self.insights_metadata = None
        self.image_id = None
        self.accent_color = None
        self.visual_words = None
        self._type = 'ImageObject'


class SearchResultsAnswer(Answer):
    """Defines a search result answer.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Images

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar total_estimated_matches: The estimated number of webpages that are
     relevant to the query. Use this number along with the count and offset
     query parameters to page the results.
    :vartype total_estimated_matches: long
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'total_estimated_matches': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'total_estimated_matches': {'key': 'totalEstimatedMatches', 'type': 'long'},
    }

    _subtype_map = {
        '_type': {'Images': 'Images'}
    }

    def __init__(self, **kwargs):
        super(SearchResultsAnswer, self).__init__(**kwargs)
        self.total_estimated_matches = None
        self._type = 'SearchResultsAnswer'


class Images(SearchResultsAnswer):
    """Defines an image answer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar total_estimated_matches: The estimated number of webpages that are
     relevant to the query. Use this number along with the count and offset
     query parameters to page the results.
    :vartype total_estimated_matches: long
    :ivar next_offset: Used as part of deduping. Tells client the next offset
     that client should use in the next pagination request
    :vartype next_offset: int
    :param value: Required. A list of image objects that are relevant to the
     query. If there are no results, the List is empty.
    :type value:
     list[~azure.cognitiveservices.search.imagesearch.models.ImageObject]
    :ivar query_expansions: A list of expanded queries that narrows the
     original query. For example, if the query was Microsoft Surface, the
     expanded queries might be: Microsoft Surface Pro 3, Microsoft Surface RT,
     Microsoft Surface Phone, and Microsoft Surface Hub.
    :vartype query_expansions:
     list[~azure.cognitiveservices.search.imagesearch.models.Query]
    :ivar pivot_suggestions: A list of segments in the original query. For
     example, if the query was Red Flowers, Bing might segment the query into
     Red and Flowers. The Flowers pivot may contain query suggestions such as
     Red Peonies and Red Daisies, and the Red pivot may contain query
     suggestions such as Green Flowers and Yellow Flowers.
    :vartype pivot_suggestions:
     list[~azure.cognitiveservices.search.imagesearch.models.PivotSuggestions]
    :ivar similar_terms: A list of terms that are similar in meaning to the
     user's query term.
    :vartype similar_terms:
     list[~azure.cognitiveservices.search.imagesearch.models.Query]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'total_estimated_matches': {'readonly': True},
        'next_offset': {'readonly': True},
        'value': {'required': True},
        'query_expansions': {'readonly': True},
        'pivot_suggestions': {'readonly': True},
        'similar_terms': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'total_estimated_matches': {'key': 'totalEstimatedMatches', 'type': 'long'},
        'next_offset': {'key': 'nextOffset', 'type': 'int'},
        'value': {'key': 'value', 'type': '[ImageObject]'},
        'query_expansions': {'key': 'queryExpansions', 'type': '[Query]'},
        'pivot_suggestions': {'key': 'pivotSuggestions', 'type': '[PivotSuggestions]'},
        'similar_terms': {'key': 'similarTerms', 'type': '[Query]'},
    }

    def __init__(self, **kwargs):
        super(Images, self).__init__(**kwargs)
        self.next_offset = None
        self.value = kwargs.get('value', None)
        self.query_expansions = None
        self.pivot_suggestions = None
        self.similar_terms = None
        self._type = 'Images'


class ImagesImageMetadata(Model):
    """Defines a count of the number of websites where you can shop or perform
    other actions related to the image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar shopping_sources_count: The number of websites that offer goods of
     the products seen in the image.
    :vartype shopping_sources_count: int
    :ivar recipe_sources_count: The number of websites that offer recipes of
     the food seen in the image.
    :vartype recipe_sources_count: int
    :ivar aggregate_offer: A summary of the online offers of products found in
     the image. For example, if the image is of a dress, the offer might
     identify the lowest price and the number of offers found. Only visually
     similar products insights include this field. The offer includes the
     following fields: Name, AggregateRating, OfferCount, and LowPrice.
    :vartype aggregate_offer:
     ~azure.cognitiveservices.search.imagesearch.models.AggregateOffer
    """

    _validation = {
        'shopping_sources_count': {'readonly': True},
        'recipe_sources_count': {'readonly': True},
        'aggregate_offer': {'readonly': True},
    }

    _attribute_map = {
        'shopping_sources_count': {'key': 'shoppingSourcesCount', 'type': 'int'},
        'recipe_sources_count': {'key': 'recipeSourcesCount', 'type': 'int'},
        'aggregate_offer': {'key': 'aggregateOffer', 'type': 'AggregateOffer'},
    }

    def __init__(self, **kwargs):
        super(ImagesImageMetadata, self).__init__(**kwargs)
        self.shopping_sources_count = None
        self.recipe_sources_count = None
        self.aggregate_offer = None


class ImagesModule(Model):
    """Defines a list of images.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: A list of images.
    :vartype value:
     list[~azure.cognitiveservices.search.imagesearch.models.ImageObject]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ImageObject]'},
    }

    def __init__(self, **kwargs):
        super(ImagesModule, self).__init__(**kwargs)
        self.value = None


class ImageTagsModule(Model):
    """Defines the characteristics of content found in an image.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of tags that describe the characteristics
     of the content found in the image. For example, if the image is of a
     musical artist, the list might include Female, Dress, and Music to
     indicate the person is female music artist that's wearing a dress.
    :type value:
     list[~azure.cognitiveservices.search.imagesearch.models.InsightsTag]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InsightsTag]'},
    }

    def __init__(self, **kwargs):
        super(ImageTagsModule, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class InsightsTag(Model):
    """Defines a characteristic of the content found in the image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the characteristic. For example, cat, kitty,
     calico cat.
    :vartype name: str
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InsightsTag, self).__init__(**kwargs)
        self.name = None


class Intangible(Thing):
    """A utility class that serves as the umbrella for a number of 'intangible'
    things such as quantities, structured values, etc.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StructuredValue

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'StructuredValue': 'StructuredValue'}
    }

    def __init__(self, **kwargs):
        super(Intangible, self).__init__(**kwargs)
        self._type = 'Intangible'


class StructuredValue(Intangible):
    """StructuredValue.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: NormalizedRectangle

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'NormalizedRectangle': 'NormalizedRectangle'}
    }

    def __init__(self, **kwargs):
        super(StructuredValue, self).__init__(**kwargs)
        self._type = 'StructuredValue'


class NormalizedRectangle(StructuredValue):
    """Defines a region of an image. The region is defined by the coordinates of
    the top, left corner and bottom, right corner of the region. The
    coordinates are fractional values of the original image's width and height
    in the range 0.0 through 1.0.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :param left: Required. The left coordinate.
    :type left: float
    :param top: Required. The top coordinate
    :type top: float
    :param right: Required. The right coordinate
    :type right: float
    :param bottom: Required. The bottom coordinate
    :type bottom: float
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'left': {'required': True},
        'top': {'required': True},
        'right': {'required': True},
        'bottom': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'left': {'key': 'left', 'type': 'float'},
        'top': {'key': 'top', 'type': 'float'},
        'right': {'key': 'right', 'type': 'float'},
        'bottom': {'key': 'bottom', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(NormalizedRectangle, self).__init__(**kwargs)
        self.left = kwargs.get('left', None)
        self.top = kwargs.get('top', None)
        self.right = kwargs.get('right', None)
        self.bottom = kwargs.get('bottom', None)
        self._type = 'NormalizedRectangle'


class Organization(Thing):
    """Defines an organization.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Organization, self).__init__(**kwargs)
        self._type = 'Organization'


class Person(Thing):
    """Defines a person.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar job_title: The person's job title.
    :vartype job_title: str
    :ivar twitter_profile: The URL of the person's twitter profile.
    :vartype twitter_profile: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'job_title': {'readonly': True},
        'twitter_profile': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'job_title': {'key': 'jobTitle', 'type': 'str'},
        'twitter_profile': {'key': 'twitterProfile', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Person, self).__init__(**kwargs)
        self.job_title = None
        self.twitter_profile = None
        self._type = 'Person'


class PivotSuggestions(Model):
    """Defines the pivot segment.

    All required parameters must be populated in order to send to Azure.

    :param pivot: Required. The segment from the original query to pivot on.
    :type pivot: str
    :param suggestions: Required. A list of suggested queries for the pivot.
    :type suggestions:
     list[~azure.cognitiveservices.search.imagesearch.models.Query]
    """

    _validation = {
        'pivot': {'required': True},
        'suggestions': {'required': True},
    }

    _attribute_map = {
        'pivot': {'key': 'pivot', 'type': 'str'},
        'suggestions': {'key': 'suggestions', 'type': '[Query]'},
    }

    def __init__(self, **kwargs):
        super(PivotSuggestions, self).__init__(**kwargs)
        self.pivot = kwargs.get('pivot', None)
        self.suggestions = kwargs.get('suggestions', None)


class Query(Model):
    """Defines a search query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param text: Required. The query string. Use this string as the query term
     in a new search request.
    :type text: str
    :ivar display_text: The display version of the query term. This version of
     the query term may contain special characters that highlight the search
     term found in the query string. The string contains the highlighting
     characters only if the query enabled hit highlighting
    :vartype display_text: str
    :ivar web_search_url: The URL that takes the user to the Bing search
     results page for the query.Only related search results include this field.
    :vartype web_search_url: str
    :ivar search_link: The URL that you use to get the results of the related
     search. Before using the URL, you must append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header. Use this URL
     if you're displaying the results in your own user interface. Otherwise,
     use the webSearchUrl URL.
    :vartype search_link: str
    :ivar thumbnail: The URL to a thumbnail of a related image.
    :vartype thumbnail:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    """

    _validation = {
        'text': {'required': True},
        'display_text': {'readonly': True},
        'web_search_url': {'readonly': True},
        'search_link': {'readonly': True},
        'thumbnail': {'readonly': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'display_text': {'key': 'displayText', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'search_link': {'key': 'searchLink', 'type': 'str'},
        'thumbnail': {'key': 'thumbnail', 'type': 'ImageObject'},
    }

    def __init__(self, **kwargs):
        super(Query, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.display_text = None
        self.web_search_url = None
        self.search_link = None
        self.thumbnail = None


class Recipe(CreativeWork):
    """Defines a cooking recipe.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.imagesearch.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work
    :vartype text: str
    :ivar cook_time: The amount of time the food takes to cook. For example,
     PT25M. For information about the time format, see
     http://en.wikipedia.org/wiki/ISO_8601#Durations.
    :vartype cook_time: str
    :ivar prep_time: The amount of time required to prepare the ingredients.
     For example, PT15M. For information about the time format, see
     http://en.wikipedia.org/wiki/ISO_8601#Durations.
    :vartype prep_time: str
    :ivar total_time: The total amount of time it takes to prepare and cook
     the recipe. For example, PT45M. For information about the time format, see
     http://en.wikipedia.org/wiki/ISO_8601#Durations.
    :vartype total_time: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'cook_time': {'readonly': True},
        'prep_time': {'readonly': True},
        'total_time': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'cook_time': {'key': 'cookTime', 'type': 'str'},
        'prep_time': {'key': 'prepTime', 'type': 'str'},
        'total_time': {'key': 'totalTime', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Recipe, self).__init__(**kwargs)
        self.cook_time = None
        self.prep_time = None
        self.total_time = None
        self._type = 'Recipe'


class RecipesModule(Model):
    """Defines a list of recipes.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: A list of recipes.
    :vartype value:
     list[~azure.cognitiveservices.search.imagesearch.models.Recipe]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Recipe]'},
    }

    def __init__(self, **kwargs):
        super(RecipesModule, self).__init__(**kwargs)
        self.value = None


class RecognizedEntitiesModule(Model):
    """Defines a list of previously recognized entities.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: A list of recognized entities.
    :vartype value:
     list[~azure.cognitiveservices.search.imagesearch.models.RecognizedEntityGroup]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RecognizedEntityGroup]'},
    }

    def __init__(self, **kwargs):
        super(RecognizedEntitiesModule, self).__init__(**kwargs)
        self.value = None


class RecognizedEntity(Response):
    """Defines a recognized entity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar entity: The entity that was recognized. The following are the
     possible entity objects: Person
    :vartype entity: ~azure.cognitiveservices.search.imagesearch.models.Thing
    :ivar match_confidence: The confidence that Bing has that the entity in
     the image matches this entity. The confidence ranges from 0.0 through 1.0
     with 1.0 being very confident.
    :vartype match_confidence: float
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'entity': {'readonly': True},
        'match_confidence': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'entity': {'key': 'entity', 'type': 'Thing'},
        'match_confidence': {'key': 'matchConfidence', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(RecognizedEntity, self).__init__(**kwargs)
        self.entity = None
        self.match_confidence = None
        self._type = 'RecognizedEntity'


class RecognizedEntityGroup(Model):
    """Defines a group of previously recognized entities.

    All required parameters must be populated in order to send to Azure.

    :param recognized_entity_regions: Required. The regions of the image that
     contain entities.
    :type recognized_entity_regions:
     list[~azure.cognitiveservices.search.imagesearch.models.RecognizedEntityRegion]
    :param name: Required. The name of the group where images of the entity
     were also found. The following are possible groups.
     CelebRecognitionAnnotations: Similar to CelebrityAnnotations but provides
     a higher probability of an accurate match. CelebrityAnnotations: Contains
     celebrities such as actors, politicians, athletes, and historical figures.
    :type name: str
    """

    _validation = {
        'recognized_entity_regions': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'recognized_entity_regions': {'key': 'recognizedEntityRegions', 'type': '[RecognizedEntityRegion]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RecognizedEntityGroup, self).__init__(**kwargs)
        self.recognized_entity_regions = kwargs.get('recognized_entity_regions', None)
        self.name = kwargs.get('name', None)


class RecognizedEntityRegion(Response):
    """Defines a region of the image where an entity was found and a list of
    entities that might match it.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar region: A region of the image that contains an entity. The values of
     the rectangle are relative to the width and height of the original image
     and are in the range 0.0 through 1.0. For example, if the image is 300x200
     and the region's top, left corner is at point (10, 20) and the bottom,
     right corner is at point (290, 150), then the normalized rectangle is:
     Left = 0.0333333333333333, Top = 0.1, Right = 0.9666666666666667, Bottom =
     0.75. For people, the region represents the person's face.
    :vartype region:
     ~azure.cognitiveservices.search.imagesearch.models.NormalizedRectangle
    :ivar matching_entities: A list of entities that Bing believes match the
     entity found in the region. The entities are in descending order of
     confidence (see the matchConfidence field of RecognizedEntity).
    :vartype matching_entities:
     list[~azure.cognitiveservices.search.imagesearch.models.RecognizedEntity]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'region': {'readonly': True},
        'matching_entities': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'region': {'key': 'region', 'type': 'NormalizedRectangle'},
        'matching_entities': {'key': 'matchingEntities', 'type': '[RecognizedEntity]'},
    }

    def __init__(self, **kwargs):
        super(RecognizedEntityRegion, self).__init__(**kwargs)
        self.region = None
        self.matching_entities = None
        self._type = 'RecognizedEntityRegion'


class RelatedCollectionsModule(Model):
    """Defines a list of webpages that contain related images.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: A list of webpages that contain related images.
    :vartype value:
     list[~azure.cognitiveservices.search.imagesearch.models.ImageGallery]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ImageGallery]'},
    }

    def __init__(self, **kwargs):
        super(RelatedCollectionsModule, self).__init__(**kwargs)
        self.value = None


class RelatedSearchesModule(Model):
    """Defines a list of related searches.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: A list of related searches.
    :vartype value:
     list[~azure.cognitiveservices.search.imagesearch.models.Query]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Query]'},
    }

    def __init__(self, **kwargs):
        super(RelatedSearchesModule, self).__init__(**kwargs)
        self.value = None


class TrendingImages(Response):
    """The top-level object that the response includes when a trending images
    request succeeds.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :param categories: Required. A list that identifies categories of images
     and a list of trending images in that category.
    :type categories:
     list[~azure.cognitiveservices.search.imagesearch.models.TrendingImagesCategory]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'categories': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'categories': {'key': 'categories', 'type': '[TrendingImagesCategory]'},
    }

    def __init__(self, **kwargs):
        super(TrendingImages, self).__init__(**kwargs)
        self.categories = kwargs.get('categories', None)
        self._type = 'TrendingImages'


class TrendingImagesCategory(Model):
    """Defines the category of trending images.

    All required parameters must be populated in order to send to Azure.

    :param title: Required. The name of the image category. For example,
     Popular People Searches.
    :type title: str
    :param tiles: Required. A list of images that are trending in the
     category. Each tile contains an image and a URL that returns more images
     of the subject. For example, if the category is Popular People Searches,
     the image is of a popular person and the URL would return more images of
     that person.
    :type tiles:
     list[~azure.cognitiveservices.search.imagesearch.models.TrendingImagesTile]
    """

    _validation = {
        'title': {'required': True},
        'tiles': {'required': True},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'tiles': {'key': 'tiles', 'type': '[TrendingImagesTile]'},
    }

    def __init__(self, **kwargs):
        super(TrendingImagesCategory, self).__init__(**kwargs)
        self.title = kwargs.get('title', None)
        self.tiles = kwargs.get('tiles', None)


class TrendingImagesTile(Model):
    """Defines an image tile.

    All required parameters must be populated in order to send to Azure.

    :param query: Required. A query that returns a Bing search results page
     with more images of the subject. For example, if the category is Popular
     People Searches, then the thumbnail is of a popular person. The query
     would return a Bing search results page with more images of that person.
    :type query: ~azure.cognitiveservices.search.imagesearch.models.Query
    :param image: Required. The image's thumbnail.
    :type image:
     ~azure.cognitiveservices.search.imagesearch.models.ImageObject
    """

    _validation = {
        'query': {'required': True},
        'image': {'required': True},
    }

    _attribute_map = {
        'query': {'key': 'query', 'type': 'Query'},
        'image': {'key': 'image', 'type': 'ImageObject'},
    }

    def __init__(self, **kwargs):
        super(TrendingImagesTile, self).__init__(**kwargs)
        self.query = kwargs.get('query', None)
        self.image = kwargs.get('image', None)
